<div>
    @if($showModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" id="modal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white">
                <div class="mt-3">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium text-text-primary">
                            {{ $editingId ? 'Edit Pekerjaan' : 'Tambah Pekerjaan Baru' }}
                        </h3>
                        <button wire:click="closeModal" class="text-gray-400 hover:text-gray-600">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>

                    <form wire:submit.prevent="save">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- Nama Pekerjaan -->
                            <div class="md:col-span-2">
                                <label for="nama" class="block text-sm font-medium text-text-primary mb-2">Nama Pekerjaan *</label>
                                <input
                                    type="text"
                                    id="nama"
                                    wire:model="nama"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                    placeholder="Masukkan nama pekerjaan"
                                >
                                @error('nama') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- Penyedia -->
                            <div>
                                <label for="penyedia_id" class="block text-sm font-medium text-text-primary mb-2">Penyedia *</label>
                                <select
                                    id="penyedia_id"
                                    wire:model="penyedia_id"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                >
                                    <option value="">Pilih Penyedia</option>
                                    @foreach($badanUsahas as $badanUsaha)
                                        <option value="{{ $badanUsaha->id }}">{{ $badanUsaha->nama_badan_usaha }}</option>
                                    @endforeach
                                </select>
                                @error('penyedia_id') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- Paket Pekerjaan -->
                            <div>
                                <label for="paket_pekerjaan_id" class="block text-sm font-medium text-text-primary mb-2">Paket Pekerjaan</label>
                                <select
                                    id="paket_pekerjaan_id"
                                    wire:model="paket_pekerjaan_id"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                >
                                    <option value="">Pilih Paket (Opsional)</option>
                                    @foreach($paketPekerjaans as $paket)
                                        <option value="{{ $paket->id }}">{{ $paket->nama_paket }} ({{ $paket->kode_paket }})</option>
                                    @endforeach
                                </select>
                                @error('paket_pekerjaan_id') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- Tanggal Mulai -->
                            <div>
                                <label for="tanggal_mulai" class="block text-sm font-medium text-text-primary mb-2">Tanggal Mulai *</label>
                                <input
                                    type="date"
                                    id="tanggal_mulai"
                                    wire:model="tanggal_mulai"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                >
                                @error('tanggal_mulai') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- Tanggal Selesai -->
                            <div>
                                <label for="tanggal_selesai" class="block text-sm font-medium text-text-primary mb-2">Tanggal Selesai *</label>
                                <input
                                    type="date"
                                    id="tanggal_selesai"
                                    wire:model="tanggal_selesai"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                >
                                @error('tanggal_selesai') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- Lokasi -->
                            <div>
                                <label for="lokasi" class="block text-sm font-medium text-text-primary mb-2">Lokasi</label>
                                <input
                                    type="text"
                                    id="lokasi"
                                    wire:model="lokasi"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                    placeholder="Masukkan lokasi pekerjaan"
                                >
                                @error('lokasi') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- Tenaga Ahli -->
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-text-primary mb-2">Tenaga Ahli *</label>
                                <div class="border border-gray-300 rounded-md p-3 max-h-40 overflow-y-auto">
                                    @foreach($tenagaAhlis as $tenagaAhli)
                                        <label class="flex items-center mb-2">
                                            <input
                                                type="checkbox"
                                                wire:model="tenaga_ahli"
                                                value="{{ $tenagaAhli->id }}"
                                                class="rounded border-gray-300 text-primary-600 shadow-sm focus:border-primary-300 focus:ring focus:ring-primary-200 focus:ring-opacity-50"
                                            >
                                            <span class="ml-2 text-sm text-text-primary">
                                                {{ $tenagaAhli->nama_tenaga_ahli }}
                                                <span class="text-text-secondary">({{ $tenagaAhli->kualifikasi_skk }})</span>
                                            </span>
                                        </label>
                                    @endforeach
                                </div>
                                @error('tenaga_ahli') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- Deskripsi -->
                            <div class="md:col-span-2">
                                <label for="deskripsi" class="block text-sm font-medium text-text-primary mb-2">Deskripsi</label>
                                <textarea
                                    id="deskripsi"
                                    wire:model="deskripsi"
                                    rows="3"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                    placeholder="Masukkan deskripsi pekerjaan (opsional)"
                                ></textarea>
                                @error('deskripsi') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>
                        </div>

                        <div class="flex justify-end space-x-3 mt-6">
                            <button
                                type="button"
                                wire:click="closeModal"
                                class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500"
                            >
                                Batal
                            </button>
                            <button
                                type="submit"
                                wire:loading.attr="disabled"
                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 disabled:opacity-50"
                            >
                                <span wire:loading.remove>Simpan</span>
                                <span wire:loading>Menyimpan...</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif
</div>
