<div>
    @if($showModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" id="modal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-2/3 shadow-lg rounded-md bg-white">
                <div class="mt-3">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium text-text-primary">
                            {{ $editingId ? 'Edit Paket Pekerjaan' : 'Tambah Paket Pekerjaan Baru' }}
                        </h3>
                        <button wire:click="closeModal" class="text-gray-400 hover:text-gray-600">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>

                    <form wire:submit.prevent="save">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- Kode Paket -->
                            <div>
                                <label for="kode_paket" class="block text-sm font-medium text-text-primary mb-2">Kode Paket *</label>
                                <input
                                    type="text"
                                    id="kode_paket"
                                    wire:model="kode_paket"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                    placeholder="Masukkan kode paket"
                                >
                                @error('kode_paket') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- Status -->
                            <div>
                                <label for="status" class="block text-sm font-medium text-text-primary mb-2">Status *</label>
                                <select
                                    id="status"
                                    wire:model="status"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                >
                                    @foreach($statusList as $key => $value)
                                        <option value="{{ $key }}">{{ $value }}</option>
                                    @endforeach
                                </select>
                                @error('status') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- Nama Paket -->
                            <div class="md:col-span-2">
                                <label for="nama_paket" class="block text-sm font-medium text-text-primary mb-2">Nama Paket *</label>
                                <input
                                    type="text"
                                    id="nama_paket"
                                    wire:model="nama_paket"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500"
                                    placeholder="Masukkan nama paket pekerjaan"
                                >
                                @error('nama_paket') <span class="text-sm text-red-600">{{ $message }}</span> @enderror
                            </div>

                            <!-- OPD -->
                            <div>
                                <label for="opd_id" class="block text-sm font-medium text-text-primary mb-2">OPD *</label>
                                <select
                                    id="opd_id"
                                    wire:model="opd_id"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500 @error('opd_id') border-red-500 @enderror"
                                >
                                    <option value="">Pilih OPD</option>
                                    @foreach($opds as $opd)
                                        <option value="{{ $opd->id }}">{{ $opd->nama_opd }} ({{ $opd->kode_opd }})</option>
                                    @endforeach
                                </select>
                                @error('opd_id')
                                    <span class="text-sm text-red-600 mt-1 block">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Badan Usaha -->
                            <div>
                                <label for="badan_usaha_id" class="block text-sm font-medium text-text-primary mb-2">Badan Usaha *</label>
                                <select
                                    id="badan_usaha_id"
                                    wire:model="badan_usaha_id"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500 @error('badan_usaha_id') border-red-500 @enderror"
                                >
                                    <option value="">Pilih Badan Usaha</option>
                                    @foreach($badanUsahas as $badanUsaha)
                                        <option value="{{ $badanUsaha->id }}">{{ $badanUsaha->nama_badan_usaha }}</option>
                                    @endforeach
                                </select>
                                @error('badan_usaha_id')
                                    <span class="text-sm text-red-600 mt-1 block">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Tanggal Kontrak Mulai -->
                            <div>
                                <label for="kontrak_mulai" class="block text-sm font-medium text-text-primary mb-2">Tanggal Kontrak Mulai</label>
                                <input
                                    type="date"
                                    id="kontrak_mulai"
                                    wire:model="kontrak_mulai"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500 @error('kontrak_mulai') border-red-500 @enderror"
                                >
                                @error('kontrak_mulai')
                                    <span class="text-sm text-red-600 mt-1 block">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Tanggal Kontrak Selesai -->
                            <div>
                                <label for="kontrak_selesai" class="block text-sm font-medium text-text-primary mb-2">Tanggal Kontrak Selesai</label>
                                <input
                                    type="date"
                                    id="kontrak_selesai"
                                    wire:model="kontrak_selesai"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500 @error('kontrak_selesai') border-red-500 @enderror"
                                >
                                @error('kontrak_selesai')
                                    <span class="text-sm text-red-600 mt-1 block">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Nilai Total -->
                            <div class="md:col-span-2">
                                <label for="nilai_total" class="block text-sm font-medium text-text-primary mb-2">Nilai Total (Rp)</label>
                                <input
                                    type="number"
                                    id="nilai_total"
                                    wire:model="nilai_total"
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500 @error('nilai_total') border-red-500 @enderror"
                                    placeholder="Masukkan nilai total (opsional)"
                                    min="0"
                                    step="1000"
                                >
                                @error('nilai_total')
                                    <span class="text-sm text-red-600 mt-1 block">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Tenaga Ahli -->
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-text-primary mb-2">Tenaga Ahli *</label>
                                <div class="border border-gray-300 rounded-md p-3 max-h-48 overflow-y-auto @error('tenaga_ahli_ids') border-red-500 @enderror">
                                    @foreach($tenagaAhlis as $tenagaAhli)
                                        <label class="flex items-center mb-2 {{ !$tenagaAhli->is_available ? 'opacity-50' : '' }}">
                                            <input
                                                type="checkbox"
                                                wire:model="tenaga_ahli_ids"
                                                value="{{ $tenagaAhli->id }}"
                                                {{ !$tenagaAhli->is_available ? 'disabled' : '' }}
                                                class="rounded border-gray-300 text-primary-600 shadow-sm focus:border-primary-300 focus:ring focus:ring-primary-200 focus:ring-opacity-50"
                                            >
                                            <div class="ml-2 flex-1">
                                                <div class="flex items-center">
                                                    <span class="text-sm text-text-primary {{ !$tenagaAhli->is_available ? 'line-through' : '' }}">
                                                        {{ $tenagaAhli->nama }}
                                                    </span>
                                                    @if(!$tenagaAhli->is_available)
                                                        <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800">
                                                            <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                                                            </svg>
                                                            Tidak Tersedia
                                                        </span>
                                                    @else
                                                        <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-green-100 text-green-800">
                                                            <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                                            </svg>
                                                            Tersedia
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </label>
                                    @endforeach
                                </div>
                                @error('tenaga_ahli_ids')
                                    <span class="text-sm text-red-600 mt-1 block">{{ $message }}</span>
                                @enderror
                                <div class="mt-2 text-xs text-text-secondary">
                                    <p>• Maksimal 5 paket pekerjaan per OPD yang dapat berjalan bersamaan</p>
                                    <p>• Satu tenaga ahli hanya dapat terlibat dalam satu paket pekerjaan aktif pada waktu yang sama</p>
                                    <p>• Tenaga ahli yang tidak tersedia akan ditandai dengan status "Tidak Tersedia"</p>
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end space-x-3 mt-6">
                            <button
                                type="button"
                                wire:click="closeModal"
                                class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500"
                            >
                                Batal
                            </button>
                            <button
                                type="submit"
                                wire:loading.attr="disabled"
                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 disabled:opacity-50"
                            >
                                <span wire:loading.remove>Simpan</span>
                                <span wire:loading>Menyimpan...</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif
</div>
