<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>SIMLPJK</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
 
        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])

        <!-- Livewire Styles -->
        @livewireStyles
        <link rel="stylesheet" href="{{asset('main/assets/css/templatemo-seo-dream.css')}}">
       
      
    </head>
    <style>
        .main-banner::before{
            opacity: 0.5;
        }
    </style>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-background">
            @include('layouts.navigation')

            <!-- Page Heading -->
            @isset($header)
                <header class="bg-surface shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        {{ $header }}
                    </div>
                </header>
            @endisset

            <!-- Page Content -->
            <main class="main-banner">
                <div style="position:relative;z-index:2">
                {{ $slot }}
                </div>
            </main>
        </div>

        <!-- Livewire Scripts -->

       
        <script src="{{ asset('vendor/livewire/livewire.js') }}"></script>
      
        <script>
            // Fallback untuk Livewire jika CDN tidak tersedia
            if (typeof Livewire === 'undefined') {
                document.addEventListener('DOMContentLoaded', function() {
                    // Reload halaman jika Livewire tidak terload
                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                });
            }
        </script>
    </body>
</html>
