<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pekerjaan extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'nama',
        'penyedia_id',
        'paket_pekerjaan_id',
        'tanggal_mulai',
        'tanggal_selesai',
        'deskripsi',
        'lokasi'
    ];

    protected $casts = [
        'tanggal_mulai' => 'date',
        'tanggal_selesai' => 'date'
    ];

    public function penyedia()
    {
        return $this->belongsTo(BadanUsaha::class, 'penyedia_id');
    }

    public function paketPekerjaan()
    {
        return $this->belongsTo(PaketPekerjaan::class, 'paket_pekerjaan_id');
    }

    public function tenagaAhli()
    {
        return $this->belongsToMany(TenagaAhli::class, 'pekerjaan_tenaga_ahli');
    }
}
