<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaketPekerjaan extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'kode_paket',
        'nama_paket',
        'nilai_total',
        'status',
        'kontrak_mulai',
        'kontrak_selesai',
        'opd_id',
        'badan_usaha_id',
    ];

    protected $casts = [
        'nilai_total' => 'decimal:2',
        'status' => 'string',
        'kontrak_mulai' => 'date',
        'kontrak_selesai' => 'date',
    ];

    public const STATUS_LIST = [
        'perencanaan' => 'Perencanaan',
        'tender' => 'Tender',
        'progres' => 'Progres',
        'selesai' => 'Selesai'
    ];

    public function pekerjaans()
    {
        return $this->hasMany(Pekerjaan::class);
    }

    public function opd()
    {
        return $this->belongsTo(OPD::class);
    }

    public function badanUsaha()
    {
        return $this->belongsTo(BadanUsaha::class);
    }

    public function tenagaAhli()
    {
        return $this->belongsToMany(TenagaAhli::class, 'paket_pekerjaan_tenaga_ahli');
    }
}
