<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Legalitas extends Model
{
    protected $table = 'legalitas';

    protected $fillable = [
        'badan_usaha_id',
        'nomor_akte',
        'tanggal',
        'nama_notaris',
        'nomor_pengesahan'
    ];

    protected $casts = [
        'tanggal' => 'date'
    ];

    public function badanUsaha(): BelongsTo
    {
        return $this->belongsTo(BadanUsaha::class);
    }
}
