<?php

namespace App\Livewire\TenagaAhli;

use App\Models\TenagaAhli;
use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;

class Form extends Component
{
    public $showModal = false;

    #[Rule('required|min:3|max:255')]
    public $nama_tenaga_ahli = '';

    #[Rule('required|date')]
    public $masa_berlaku_skk = '';

    #[Rule('required|in:KLASIFIKASI SIPIL,KLASIFIKASI MEKANIKAL,KLASIFIKASI TATA LINGKUNGAN,KLASIFIKASI MANAJEMEN PELAKSANAAN,KLASIFIKASI ARSITEKTUR LANSKAP, ILUMINASI DAN DESAIN INTERIOR,KLASIFIKASI PERENCANAAN WILAYAH DAN KOTA,KLASIFIKASI SAINS DAN REKAYASA TEKNIK')]
    public $kualifikasi_skk = '';

    public $editingId = null;

    #[On('form-show')]
    public function show($tenagaAhliId = null)
    {
        $this->resetForm();
        $this->showModal = true;

        if ($tenagaAhliId) {
            $this->editingId = $tenagaAhliId;
            $this->loadData();
        }
    }

    public function loadData()
    {
        $tenagaAhli = TenagaAhli::find($this->editingId);

        $this->nama_tenaga_ahli = $tenagaAhli->nama_tenaga_ahli;
        $this->masa_berlaku_skk = $tenagaAhli->masa_berlaku_skk->format('Y-m-d');
        $this->kualifikasi_skk = $tenagaAhli->kualifikasi_skk;
    }

    public function save()
    {
        $this->validate();

        if ($this->editingId) {
            TenagaAhli::find($this->editingId)->update([
                'nama_tenaga_ahli' => $this->nama_tenaga_ahli,
                'masa_berlaku_skk' => $this->masa_berlaku_skk,
                'kualifikasi_skk' => $this->kualifikasi_skk
            ]);
        } else {
            TenagaAhli::create([
                'nama_tenaga_ahli' => $this->nama_tenaga_ahli,
                'masa_berlaku_skk' => $this->masa_berlaku_skk,
                'kualifikasi_skk' => $this->kualifikasi_skk
            ]);
        }

        $this->dispatch('item-saved');
        $this->closeModal();
    }

    public function resetForm()
    {
        $this->reset(['nama_tenaga_ahli', 'masa_berlaku_skk', 'kualifikasi_skk', 'editingId']);
        $this->resetValidation();
    }

    public function closeModal()
    {
        $this->showModal = false;
        $this->resetForm();
        $this->resetValidation();
    }

    public function render()
    {
        return view('livewire.tenaga-ahli.form', [
            'kualifikasiList' => [
                'KLASIFIKASI SIPIL',
                'KLASIFIKASI MEKANIKAL',
                'KLASIFIKASI TATA LINGKUNGAN',
                'KLASIFIKASI MANAJEMEN PELAKSANAAN',
                'KLASIFIKASI ARSITEKTUR LANSKAP, ILUMINASI DAN DESAIN INTERIOR',
                'KLASIFIKASI PERENCANAAN WILAYAH DAN KOTA',
                'KLASIFIKASI SAINS DAN REKAYASA TEKNIK'
            ]
        ]);
    }
}
