<?php

namespace App\Livewire\TenagaAhli;

use App\Models\TenagaAhli;
use App\Models\TenagaAhli_ska;
use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;

class Detail extends Component
{
   public $tk_id;
    public $tk;
    public $showModal = false;
    public $activeTab = 'ska';

    public function mount($tk_id = null)
    {
        if ($tk_id) {
            $this->loadDetail($tk_id);
        }

    }
     public function loadDetail($id)
    {
        $this->tk_id = $id;
        $this->tk = TenagaAhli::with([
            'tenaga_ska','tenaga_skk','tenaga_skt'
        ])->find($id);

        $this->showModal = true;
    }

    #[On('loadDetail')]
    public function handleLoadDetail($id)
    {
        $this->loadDetail($id);
    }

    public function closeModal()
    {
        $this->showModal = false;
        $this->tk = null;
        $this->tk_id = null;
    }

    public function render()
    {
        return view('livewire.tenaga-ahli.detail');
    }
}
