<?php

namespace App\Livewire;

use App\Models\BadanUsaha;
use Livewire\Attributes\On;
use Livewire\Component;

class PenyediaDetail extends Component
{
    public $badanUsahaId;
    public $badanUsaha;
    public $showModal = false;
    public $activeTab = 'profile';

    public function mount($badanUsahaId = null)
    {
        if ($badanUsahaId) {
            $this->loadDetail($badanUsahaId);
        }
    }

    public function loadDetail($id)
    {
        $this->badanUsahaId = $id;
        $this->badanUsaha = BadanUsaha::with([
            'kbli2017', 'kbli2020', 'legalitas',
            'pengurus', 'pjsk2017', 'pjsk2020'
        ])->find($id);

        $this->showModal = true;
    }

    #[On('loadDetail')]
    public function handleLoadDetail($id)
    {
        $this->loadDetail($id);
    }

    public function closeModal()
    {
        $this->showModal = false;
        $this->badanUsaha = null;
        $this->badanUsahaId = null;
    }

    public function render()
    {
        return view('livewire.penyedia-detail');
    }
}
