<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">

	<meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

	<meta name="description" content="Neon Admin Panel" />
	<meta name="author" content="" />

	<link rel="icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>">

	<title>Sistem Informasi Perikanan Lamongan | Login</title>

	<link rel="stylesheet" href="<?php echo e(asset('assets/js/jquery-ui/css/no-theme/jquery-ui-1.10.3.custom.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/font-icons/entypo/css/entypo.css')); ?>">
	<link rel="stylesheet" href="//fonts.googleapis.com/css?family=Noto+Sans:400,700,400italic">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/neon-core.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/neon-theme.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/neon-forms.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>">

	<script src="<?php echo e(asset('assets/js/jquery-1.11.3.min.js')); ?>"></script>


</head>
<body class="page-body login-page login-form-fall">


<!-- This is needed when you send requests via Ajax -->
<script type="text/javascript">
var baseurl = '';
</script>

<div class="login-container">
	
	<div class="login-header login-caret">
		
		<div class="login-content">
			
			<a href="<?php echo e(url('/login')); ?>" class="logo">
				<img src="<?php echo e(asset('logo(2).png')); ?>" width="100" height="100" alt="" />
			</a>
			
			<p class="description" style="color: #fff;">Dear user, log in to access the admin area!</p>
			
			<!-- progress bar indicator -->
			<div class="login-progressbar-indicator">
				<h3>43%</h3>
				<span>logging in...</span>
			</div>
		</div>
		
	</div>
	
	<div class="login-progressbar">
		<div></div>
	</div>
	
	<div class="login-form">
		
		<div class="login-content">
			<?php if(session('error')): ?>
				<div class="alert alert-danger" role="alert">
					<?php echo e(session('error')); ?>

			  	</div>
			<?php endif; ?>
			
			<form method="POST" action="<?php echo e(route('login')); ?>" role="form">
				<?php echo csrf_field(); ?>
				<div class="form-group">
					
					<div class="input-group">
						<div class="input-group-addon">
							<i class="entypo-user"></i>
						</div>
						
						<input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus id="email" placeholder="Email"/>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
					
				</div>
				
				<div class="form-group">
					
					<div class="input-group">
						<div class="input-group-addon">
							<i class="entypo-key"></i>
						</div>
						
						<input id="password" type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" required autocomplete="current-password" placeholder="Password"/>
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
				
				</div>
				<div class="form-group">
					
					<div class="input-group">
						<div class="input-group-addon">
							<i class="entypo-back-in-time"></i>
						</div>
						<select class="form-control" name="tahun" id="tahun" required>
							<option value="">--Pilih Tahun --</option>
							<?php for($th = Date('Y'); $th >= 2014; $th--): ?>
							<option value="<?php echo e($th); ?>"><?php echo e($th); ?></option>
							<?php endfor; ?>
						</select>
					</div>
				</div>
				
				<div class="form-group">
					<button type="submit" class="btn btn-primary btn-block btn-login">
						<i class="entypo-login"></i>
						Masuk
					</button>
				</div>
				
			</form>
		</div>
		
	</div>
	
</div>


	<!-- Bottom scripts (common) -->
	<script src="<?php echo e(asset('assets/js/gsap/TweenMax.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/jquery-ui/js/jquery-ui-1.10.3.minimal.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/bootstrap.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/joinable.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/resizeable.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/neon-api.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/jquery.validate.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/neon-login.js')); ?>"></script>


	<!-- JavaScripts initializations and stuff -->
	<script src="<?php echo e(asset('assets/js/neon-custom.js')); ?>"></script>


	<!-- Demo Settings -->
	<script src="<?php echo e(asset('assets/js/neon-demo.js')); ?>"></script>

</body>
</html><?php /**PATH /var/www/html/perikanan/resources/views/auth/login.blade.php ENDPATH**/ ?>