<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta name="description" content="Perikanan Lamongan" />
	<meta name="author" content="Sambora07" />

	<link rel="icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>">

	<title>Perikanan Lamongan</title>

	<link rel="stylesheet" href="<?php echo e(asset('assets/js/jquery-ui/css/no-theme/jquery-ui-1.10.3.custom.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/font-icons/entypo/css/entypo.css')); ?>">
	<link rel="stylesheet" href="//fonts.googleapis.com/css?family=Noto+Sans:400,700,400italic">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/neon-core.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/neon-theme.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/neon-forms.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/skins/facebook.css')); ?>">

	<script src="<?php echo e(asset('assets/js/jquery-1.11.3.min.js')); ?>"></script>

    <?php echo $__env->yieldContent('css'); ?>

</head>
<body class="page-body skin-facebook">

<div class="page-container"><!-- add class "sidebar-collapsed" to close sidebar by default, "chat-visible" to make chat appear always -->
	
	<div class="sidebar-menu">

		<div class="sidebar-menu-inner">
			
			<header class="logo-env">

				<!-- logo -->
				<!--<div class="logo">-->
				<!--	<a href="<?php echo e(url('/home')); ?>">-->
				<!--		<img src="<?php echo e(asset('logo.png')); ?>" width="120" height="100" alt="" />-->
				<!--	</a>-->
				<!--</div>-->

				<!-- logo collapse icon -->
				<div class="sidebar-collapse">
					<a href="#" class="sidebar-collapse-icon"><!-- add class "with-animation" if you want sidebar to have animation during expanding/collapsing transition -->
						<i class="entypo-menu"></i>
					</a>
				</div>

								
				<!-- open/close menu icon (do not remove if you want to enable menu on mobile devices) -->
				<div class="sidebar-mobile-menu visible-xs">
					<a href="#" class="with-animation"><!-- add class "with-animation" to support animation -->
						<i class="entypo-menu"></i>
					</a>
				</div>

			</header>
			
			<div class="sidebar-user-info">

				<div class="sui-normal">
					<a href="#" class="user-link">
						<img src="<?php echo e(asset('logo(2).png')); ?>" width="55" alt="" class="img-circle" />

						<span>Welcome,</span>
						<strong><?php echo e(Auth::user()->name); ?></strong>
					</a>
				</div>

				<div class="sui-hover inline-links animate-in"><!-- You can remove "inline-links" class to make links appear vertically, class "animate-in" will make A elements animateable when click on user profile -->


					<a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
						<i class="entypo-lock"></i>
						Log Out
					</a>

                    <span class="close-sui-popup">&times;</span><!-- this is mandatory -->				
                </div>
			</div>
			
			<?php
				$tahun = Auth::user()->tahun_data;
			?>
									
			<ul id="main-menu" class="main-menu">
				<!-- add class "multiple-expanded" to allow multiple submenus to open -->
				<!-- class "auto-inherit-active-class" will automatically add "active" class for parent elements who are marked already with class "active" -->
                <li class="<?php echo e(Request::is('home*') ? 'active' : ''); ?>">
					<a href="<?php echo e(url('/home')); ?>">
						<i class="entypo-gauge"></i>
						<span class="title">Dashboard</span>
					</a>
				</li>
				<li class="<?php echo e(Request::is('data*') ? 'active' : ''); ?>">
					<a href="<?php echo e(url('data')); ?>">
						<i class="entypo-monitor"></i>
						<span class="title">Data</span>
					</a>
				</li>
				<li class="<?php echo e(Request::is('harga*') ? 'active' : ''); ?>">
					<a href="<?php echo e(url('harga/1/'.$tahun)); ?>">
						<i class="entypo-credit-card"></i>
						<span class="title">Harga</span>
					</a>
				</li>
				<li class="has-sub <?php echo e(Request::is('rekap*') ? 'opened' : ''); ?>">
					<a href="#">
						<i class="entypo-book-open"></i>
						<span class="title">Rekapitulasi</span>
					</a>
					<ul>
						<li>
						    <?php if(Auth::user()->id_jabatan == 1): ?>
    							<a href="<?php echo e(url('rekap/desa/0/0/'.$tahun.'/0')); ?>">
    								<i class="entypo-flow-line"></i>
    								<span class="title">
    									Rekap Produksi Ikan Per Desa
    								</span>
    							</a>
							<?php else: ?>
							    <a href="<?php echo e(url('rekap/desa/'.Auth::user()->id_kecamatan.'/0/'.$tahun.'/0')); ?>">
    								<i class="entypo-flow-line"></i>
    								<span class="title">
    									Rekap Produksi Ikan Per Desa
    								</span>
    							</a>
							<?php endif; ?>
						</li>
						<li>
							<a href="<?php echo e(url('rekap/kecamatan/0/'.$tahun.'/0')); ?>">
								<i class="entypo-flow-line"></i>
								<span class="title">Rekap Produksi Ikan Per Kecamatan</span>
							</a>
						</li>
						<li>
							<a href="<?php echo e(url('rekap/tahun')); ?>">
								<i class="entypo-flow-line"></i>
								<span class="title">Rekap Produksi Ikan Per Tahun</span>
							</a>
						</li>
						<li>
						    <?php
								$thn = Date('Y');
							?>
							
							<a href="<?php echo e(url('rekap/rtp/'.$tahun.'/'.$tahun.'/0')); ?>">
								<i class="entypo-flow-line"></i>
								<span class="title">Rekap RTP</span>
							</a>
						</li>
						<li>
							<a href="<?php echo e(url('rekap/luas_lahan')); ?>">
								<i class="entypo-flow-line"></i>
								<span class="title">Rekap Luasan Lahan</span>
							</a>
						</li>
					</ul>
				</li>
				<?php if(Auth::user()->id_jabatan == 1): ?>
				<li class="<?php echo e(Request::is('berita*') ? 'active' : ''); ?>">
					<a href="<?php echo e(url('/berita')); ?>">
						<i class="entypo-newspaper"></i>
						<span class="title">Berita</span>
					</a>
				</li>
				<li class="has-sub <?php echo e(Request::is('pengaturan*') ? 'opened' : ''); ?>">
					<a href="#">
						<i class="entypo-cog"></i>
						<span class="title">Pengaturan</span>
					</a>
					<ul>
						<li>
							<a href="<?php echo e(url('pengaturan/kecamatan')); ?>">
								<i class="entypo-flow-line"></i>
								<span class="title">Kecamatan</span>
							</a>
						</li>
						<li>
							<a href="<?php echo e(url('pengaturan/desa')); ?>">
								<i class="entypo-flow-line"></i>
								<span class="title">Desa</span>
							</a>
						</li>
						<li>
							<a href="<?php echo e(url('pengaturan/jenis_ikan')); ?>">
								<i class="entypo-flow-line"></i>
								<span class="title">Jenis Ikan</span>
							</a>
						</li>
					</ul>
				</li>
				<?php endif; ?>
			</ul>
			
		</div>

	</div>

	<div class="main-content">
				
		<div class="row">
		
			<!-- Profile Info and Notifications -->
			<div class="col-md-6 col-sm-8 clearfix">
                <ul class="user-info pull-left pull-none-xsm">
		
					<!-- Profile Info -->
					<li class="profile-info dropdown"><!-- add class "pull-right" if you want to place this from right -->
		
						<a href="<?php echo e(url('/home')); ?>" class="dropdown-toggle" data-toggle="dropdown">
							<img src="<?php echo e(asset('logo(2).png')); ?>" alt="" class="img-circle" width="44" />
							<?php echo e(Auth::user()->name); ?>

						</a>
		
						<ul class="dropdown-menu">
		
							<!-- Reverse Caret -->
							<li class="caret"></li>
		
							<!-- Profile sub-links -->
							<li>
								<a href="extra-timeline.html">
									<i class="entypo-user"></i>
									Edit Profile
								</a>
							</li>
						</ul>
					</li>
		
				</ul>
			</div>
		
		
			<!-- Raw Links -->
			<div class="col-md-6 col-sm-4 clearfix hidden-xs">
		
				<ul class="list-inline links-list pull-right">
					<li>
						<a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
							Log Out <i class="entypo-logout right"></i>
						</a>
						<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
							<?php echo csrf_field(); ?>
						</form>
					</li>
				</ul>
		
			</div>
		
		</div>
		
        <hr />
    
        <?php echo $__env->yieldContent('konten'); ?>

		<!-- Footer -->
		<footer class="main">
			
			&copy; 2020 <strong>Perikanan Lamongan</strong>
		
		</footer>
	</div>
	
</div>


	<!-- Bottom scripts (common) -->
	<script src="<?php echo e(asset('assets/js/gsap/TweenMax.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/jquery-ui/js/jquery-ui-1.10.3.minimal.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/bootstrap.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/joinable.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/resizeable.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/neon-api.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/toastr.js')); ?>"></script>

	<!-- JavaScripts initializations and stuff -->
	<script src="<?php echo e(asset('assets/js/neon-custom.js')); ?>"></script>

	<!-- Imported scripts on this page -->
	<script src="<?php echo e(asset('assets/js/neon-chat.js')); ?>"></script>


	<!-- Demo Settings -->
	<script src="<?php echo e(asset('assets/js/neon-demo.js')); ?>"></script>

    <?php echo $__env->yieldContent('js'); ?>

</body>
</html><?php /**PATH /var/www/html/perikanan/resources/views/layouts/layout.blade.php ENDPATH**/ ?>