

<?php $__env->startSection('css'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/js/datatables/datatables.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/js/select2/select2-bootstrap.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/js/select2/select2.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('konten'); ?>
<ol class="breadcrumb bc-3" >
    <li>
        <a href="<?php echo e(url('/home')); ?>"><i class="entypo-home"></i>Beranda</a>
    </li>
    <li class="active">
        <strong>Data</strong>
    </li>
</ol>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default panel-shadow" data-collapsed="0"><!-- to apply shadow add class "panel-shadow" -->
            
            <!-- panel head -->
            <div class="panel-heading">
                <div class="row">
                    <form role="form" action="<?php echo e(url('data/download_form')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                        <div class="col-sm-3">
                            <select id="kecamatan" name="kecamatan" class="form-control" required>
                                <option value="">-- Pilih Kecamatan --</option>
                                <?php $__currentLoopData = $kecamatan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($k->id_kecamatan); ?>"><?php echo e($k->nama_kecamatan); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        </div>
                        <div class="form-group">
                        <div class="col-sm-3">
                            <select id="bulan" name="bulan" class="form-control" required>
                                <option value="">-- Pilih Bulan --</option>
                                <?php for($i = 1; $i < 13; $i++): ?>
                                    <option value="<?php echo e($i); ?>">
                                        <?php switch($i):
                                            case (1): ?>
                                                Januari
                                                <?php break; ?>
                                            <?php case (2): ?>
                                                Februari
                                                <?php break; ?>
                                            <?php case (3): ?>
                                                Maret
                                                <?php break; ?>
                                            <?php case (4): ?>
                                                April
                                                <?php break; ?>
                                            <?php case (5): ?>
                                                Mei
                                                <?php break; ?>
                                            <?php case (6): ?>
                                                Juni
                                                <?php break; ?>
                                            <?php case (7): ?>
                                                Juli
                                                <?php break; ?>
                                            <?php case (8): ?>
                                                Agustus
                                                <?php break; ?>
                                            <?php case (9): ?>
                                                September
                                                <?php break; ?>
                                            <?php case (10): ?>
                                                Oktober
                                                <?php break; ?>
                                            <?php case (11): ?>
                                                November
                                                <?php break; ?>
                                            <?php case (12): ?>
                                                Desember
                                                <?php break; ?>
                                            <?php default: ?>
                                        <?php endswitch; ?>
                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        </div>
                        <div class="col-sm-2">
                            <button type="submit" class="btn btn-primary"> <i class="entypo-download"></i> Unduh Form</button>
                        </div>
                    </form>
                    <form role="form" action="<?php echo e(url('data/upload')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="col-sm-2">
                            <input type="file" name="file_excel" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" required>
                        </div>
                        <div class="col-sm-2">
                            <button type="submit" class="btn btn-primary"> <i class="entypo-upload"></i> Unggah Excel</button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- panel body -->
            <div class="panel-body">
                <table class="table table-bordered datatable" id="table-1">
                    <thead>
                        <tr>
                            <th data-hide="phone">No.</th>
                            <th>Desa</th>
                            <th data-hide="phone">Kecamatan</th>
                            <th data-hide="phone,tablet">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $i = 1;
                            $tahun = Auth::user()->tahun_data;
                        ?>
                        <?php $__currentLoopData = $desa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="odd gradeX">
                                <td><?php echo e($i); ?></td>
                                <td><?php echo e($ds->nama_desa); ?></td>
                                <td><?php echo e($ds->nama_kecamatan); ?></td>
                                <td class="center">
                                    <a href="<?php echo e(url('data/detail/'.$ds->id_desa.'/'.$tahun.'/1')); ?>" type="button" class="btn btn-green btn-icon">
                                        Detail
                                        <i class="entypo-search"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php
                                $i++
                            ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/js/datatables/datatables.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/select2/select2.min.js')); ?>"></script>
    <script type="text/javascript">
        jQuery( document ).ready( function( $ ) {
            var $table1 = jQuery( '#table-1' );
            
            // Initialize DataTable
            $table1.DataTable( {
                "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                "bStateSave": true
            });
            
            // Initalize Select Dropdown after DataTables is created
            $table1.closest( '.dataTables_wrapper' ).find( 'select' ).select2( {
                minimumResultsForSearch: -1
            });
                    
        } );

        <?php if($errors->any()): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                var opts = {
                    "closeButton": true,
                    "debug": false,
                    "positionClass": "toast-top-right",
                    "onclick": null,
                    "showDuration": "300",
                    "hideDuration": "1000",
                    "timeOut": "10000",
                    "extendedTimeOut": "1000",
                    "showEasing": "swing",
                    "hideEasing": "linear",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                };
                
                toastr.error("<?php echo e($error); ?>", "Gagal !!!", opts);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/perikanan/resources/views/data/index.blade.php ENDPATH**/ ?>