
<?php $__env->startSection('css'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/js/datatables/datatables.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('konten'); ?>
<ol class="breadcrumb bc-3" >
    <li>
        <a href="<?php echo e(url('/home')); ?>"><i class="entypo-home"></i>Beranda</a>
    </li>
    <li class="active">
        <strong>Harga</strong>
    </li>
</ol>

<div class="row">
    <div class="col-md-12">
        
        <div class="panel panel-info" data-collapsed="0">
        
            <div class="panel-heading">
                <div class="panel-title">
                    <b>Harga Ikan | Tahun <?php echo e($tahun); ?></b>
                </div>
            </div>
            
            <div class="panel-body">
                <div class="col-md-12">
                    <div class="panel panel-primary" data-collapsed="0">
                        <div class="panel-heading">
                            <div class="panel-title">
                                <b>Pilih Jenis Lahan & Tahun</b>
                            </div>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label class="control-label">Jenis Lahan</label>
                                        <div>
                                            <select class="form-control" id="jns_lahan" name="jns_lahan">
                                                <?php $__currentLoopData = $jenis_lahan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($jl->id_lahan); ?>" <?php if($jl->id_lahan == $kl): ?> selected <?php endif; ?>><?php echo e($jl->nama_lahan); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label class="control-label">Tahun</label>
                                        <div>
                                            <select class="form-control" name="tahun" id="tahun">
                                                <option value="<?php echo e($tahun); ?>" selected><?php echo e($tahun); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label class="control-label">Tampilkan</label>
                                        <div>
                                            <button onclick="getUrl();" class="btn btn-primary"><i class="entypo-search"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="panel panel-success" data-collapsed="0">
                        <div class="panel-heading">
                            <div class="panel-title">
                                <b>Data Harga Dasar Ikan | Lahan <?php echo e($nama_lahan->nama_lahan); ?></b>
                            </div>
                        </div>
                        <div class="panel-body">
                            <table class="table table-bordered datatable" id="table_dasar">
                                <thead>
                                    <tr>
                                        <th>Bulan Ke-</th>
                                        <?php
                                            $n=1;
                                        ?>
                                        <?php $__currentLoopData = $ikan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ik): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th id="colH-<?php echo e($n); ?>" val="<?php echo e($ik->id_ikan); ?>"><?php echo e($ik->nama_ikan); ?></th>
                                        <?php
                                            $n++;
                                        ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                    <?php for($i = 1; $i <= 12; $i++): ?>
                                        <tr id="<?php echo e($i); ?>">
                                            <td><?php echo e($i); ?></td>
                                            <?php $__currentLoopData = $ikan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ikn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <td>
                                                    <?php if(count($harga) > 0): ?>
                                                        <?php $__currentLoopData = $harga; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($rep->bulan == $i && $rep->id_ikan == $ikn->id_ikan): ?>
                                                                <?php echo e($rep->harga); ?>

                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                    <?php endfor; ?>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="panel panel-success" data-collapsed="0">
                        <div class="panel-heading">
                            <div class="panel-title">
                                <b>Data Harga Total Ikan | Lahan <?php echo e($nama_lahan->nama_lahan); ?></b>
                            </div>
                        </div>
                        <div class="panel-body">
                            <div class="col-md-12" style="overflow: scroll;">
                                <table class="table table-bordered datatable">
                                    <thead>
                                        <tr>
                                            <th>Bulan Ke-</th>
                                            <?php
                                                $n=1;
                                            ?>
                                            <?php $__currentLoopData = $ikan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ik): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th><?php echo e($ik->nama_ikan); ?></th>
                                            <?php
                                                $n++;
                                            ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <th style="font-weight:bold; background-color: #dcdedc; text-align: center;">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $ikan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $in): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $tb[$in->id_ikan]=0;
                                        ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php $__currentLoopData = $data_bawah; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $db): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($db['bulan']); ?></td>
                                                <?php $__currentLoopData = $db['ikn']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <td align="right"><?php echo e(number_format($v, 0, ",", ".")); ?></td>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <td align="right" style="font-weight:bold; background-color: #dcdedc;"><?php echo e(number_format($db['ttl'], 0, ",", ".")); ?></td>
                                            </tr>
                                            <?php $__currentLoopData = $ikan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $in): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $tb[$in->id_ikan] += $db['ikn'][$in->id_ikan];
                                            ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td style="font-weight:bold; background-color: #dcdedc;">TOTAL</td>
                                            <?php
                                                $kbh = 0;
                                            ?>
                                            <?php $__currentLoopData = $tb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t => $vt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td align="right" style="font-weight:bold; background-color: #dcdedc;"><?php echo e(number_format($vt, 0, ",", ".")); ?></td>
                                            <?php
                                                $kbh+=$vt;
                                            ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <td align="right" style="font-weight:bold; background-color: #dcdedc;"><?php echo e(number_format($kbh, 0, ",", ".")); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <div class="row" align="center">
                                    <button type="button" id="btn_cetak" class="btn btn-success"> <i class="entypo-print"></i> Cetak</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/js/datatables/datatables.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jeditable.js/2.0.16/jquery.jeditable.min.js"></script>
    <script type="text/javascript">
        $( document ).ready( function() {
            $('#table_dasar').DataTable({
                "iDisplayLength": -1,
                "aLengthMenu": [[-1], ["All"]],
                "scrollX": true
            });
            $('#table_dasar td').editable("<?php echo e(url('/saveHarga')); ?>", {
                "placeholder": "0",
                "type": "number",
                "submitdata": function (value, settings) {
                    //console.log();
                    return {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        "id_ikan": $('#colH-' + $(this).parent().children().index($(this))).attr("val"),
                        "bulan": $(this).closest('tr').attr('id'),
                        "kd_lahan": $('#jns_lahan').val(),
                        "tahun": $('#tahun').val()
                    };
                }
            });
        } );
    </script>
    <script>
        function getUrl(){
            var kl, th, url;
            kl = $('#jns_lahan').val();
            th = $('#tahun').val();
            url = "<?php echo e(url('harga/')); ?>/"+kl+"/"+th;
            window.location.href = url;
        }

        $('#btn_cetak').click(function(){
            var kl, th, url;
            kl = $('#jns_lahan').val();
            th = $('#tahun').val();
            window.location = "<?php echo e(url('harga/CetakHargaTotalIkan/')); ?>/"+kl+'/'+th;
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/perikanan/resources/views/data/harga.blade.php ENDPATH**/ ?>