
<?php $__env->startSection('css'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/js/datatables/datatables.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/js/select2/select2-bootstrap.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/js/select2/select2.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('konten'); ?>
<ol class="breadcrumb bc-3" >
    <li>
        <a href="<?php echo e(url('/home')); ?>"><i class="entypo-home"></i>Beranda</a>
    </li>
    <li class="active">
        <strong>Data Kecamatan</strong>
    </li>
</ol>
<table class="table table-bordered datatable" id="table-1">
    <thead>
        <tr>
            <th>No</th>
            <th>Id Kecamatan</th>
            <th>Nama Kecamatan</th>
            <th style="text-align: center;">Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $no = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($no); ?></td>
            <td><?php echo e($dt->id_kecamatan); ?></td>
            <td><?php echo e($dt->nama_kecamatan); ?></td>
            <td style="text-align: center;">
                <div class="btn-group">
                    <button type="button" class="btn btn-gold btn-icon" onclick="edit('<?php echo e($dt->id_kecamatan); ?>');">
                        Edit
                        <i class="entypo-pencil"></i>
                    </button>
                    <a href="<?php echo e(url('pengaturan/hapus_kecamatan/'.$dt->id_kecamatan)); ?>" type="button" class="btn btn-red btn-icon" onclick="return confirm(' Yakin ingin hapus..?');">
                        Hapus
                        <i class="entypo-trash"></i>
                    </a>
                </div>
            </td>
        </tr>
        <?php
            $no++
        ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<div class="modal fade" id="modal-1">
    <div class="modal-dialog">
        <div class="modal-content">                    
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Tambah Kecamatan</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="<?php echo e(url('pengaturan/add_kecamatan')); ?>" class="form-horizontal" method="POST" enctype="multipart/form-data">
                    <?php echo e(csrf_field()); ?>

                    <div class="form-group">
                        <label for="field-1" class="col-sm-3 control-label">Id Kecamatan</label>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="id_kec" placeholder="Id Kecamatan" maxlength="6" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="field-1" class="col-sm-3 control-label">Nama Kecamatan</label>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="nama" placeholder="Nama Kecamatan">
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-red" data-dismiss="modal">Batal</button>
                <button type="submit"  class="btn btn-green">Simpan</button>
            </div>
        </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-edit">
    <div class="modal-dialog">
        <div class="modal-content">                    
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Edit Kecamatan</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="<?php echo e(url('pengaturan/update_kecamatan')); ?>" class="form-horizontal" method="POST" enctype="multipart/form-data">
                    <?php echo e(csrf_field()); ?>

                    <div class="form-group">
                        <label for="field-1" class="col-sm-3 control-label">Id Kecamatan</label>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="id_kec" id="id_kec" placeholder="Id Kecamatan" maxlength="6" readonly>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="field-1" class="col-sm-3 control-label">Nama Kecamatan</label>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="nama" id="nama" placeholder="Nama Kecamatan">
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-red" data-dismiss="modal">Batal</button>
                <button type="submit"  class="btn btn-green">Simpan</button>
            </div>
        </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('assets/js/datatables/datatables.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/js/select2/select2.min.js')); ?>"></script>
    <script type="text/javascript">
        $( document ).ready( function( $ ) {
            
            jQuery.noConflict();
            var $table1 = $( '#table-1' );
            
            // Initialize DataTable
            $table1.DataTable( {
                "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                "bStateSave": true,
                "dom": '<"toolbar"><"top"fl>rt<"bottom"ip><"clear">'
            });
            $("div.toolbar").html('<a href="javascript:;" type="button" class="btn btn-green btn-icon" onclick="showModal();">Tambah Kecamatan <i class="entypo-list-add"></i></a>');
            // Initalize Select Dropdown after DataTables is created
            $table1.closest( '.dataTables_wrapper' ).find( 'select' ).select2( {
                minimumResultsForSearch: -1
            });
        } );
    </script>

    <script>
        function showModal(){
            $('#modal-1').modal('show');
        }

        function edit(id){
            $.get(<?php echo json_encode(url('/')); ?>+"/pengaturan/get_kecamatan/" + id , function(data) {
                $('#id_kec').val(data.id_kecamatan);
                $('#nama').val(data.nama_kecamatan);
            });
            $('#modal-edit').modal('show');
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/perikanan/resources/views/pengaturan/kecamatan.blade.php ENDPATH**/ ?>