
<?php $__env->startSection('konten'); ?>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <hr class="no-top-margin" />
        </div>
    </div>	
</div>
<div class="col-lg-12">
    <h2><center>Grafik Rekapitulasi Luasan Lahan Pertahun</center></h2>
</div>
<br><br>
<section class="portfolio-widget">
	
	<div class="container">
		<div class="row">
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Awal</label>
                    <div>
                        <select class="form-control" name="t_awal" id="tahunawallahan">
                            <?php for($i = 2014; $i <= Date('Y'); $i++): ?>
                            <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Akhir</label>
                    <div>
                        <select class="form-control" name="t_akhir" id="tahunakhirlahan">
                            <?php for($i = 2014; $i <= Date('Y'); $i++): ?>
                            <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tampilkan</label>
                    <div>
                        <button id="btn-filterlahan" class="btn btn-primary"><i class="entypo-search"></i></button>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
		
            <div class="col-sm-12">
                <canvas id="chart-lahan"></canvas>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('chartjs/dist/Chart.js')); ?>"></script>

<script>
    var barChartlahan;
    $(document).ready(function () {
        var d = new Date();
        $('#tahunawallahan').val(d.getUTCFullYear());
        $('#tahunakhirlahan').val(d.getUTCFullYear());
        var tahunawal = $('#tahunawallahan').val();
        var tahunakhir = $('#tahunakhirlahan').val();
        var ctx = document.getElementById("chart-lahan").getContext("2d");
        //var barChart;
        var url = "<?php echo e(url('rekapitulasi/getRekapLahanTahun/')); ?>"+"/"+ tahunawal + "/" + tahunakhir;
        $.ajax({
            url: url,
            type: 'post',
            data: {
                "_token": "<?php echo e(csrf_token()); ?>"
            },
            dataType: 'json',
            success: function (datas) {
                //console.log(data);
                var barChartData = {
                    labels: datas['tahun'],
                    datasets: [{
                            label: 'Kolam',
                            backgroundColor: "rgba(202, 48, 6, 1)",
                            data: datas['kolam']
                    },{
                            label: 'Tambak',
                            backgroundColor: "rgba(232, 183, 48, 1)",
                            data: datas['tambak']
                    },{
                            label: 'Sawah Tambak',
                            backgroundColor: "rgba(61, 232, 48, 1)",
                            data: datas['sawah']
                    },{
                            label: 'Kerambah Jaring Apung',
                            backgroundColor: "rgba(48, 232, 198, 1)",
                            data: datas['kerambah']
                    },{
                            label: 'Kerambah Jaring Tancap',
                            backgroundColor: "rgba(148, 111, 198, 1)",
                            data: datas['tancap']
                    }]
                };
                barChartlahan = new Chart(ctx, {
                    type: 'bar',
                    data: barChartData,
                    options: {
                        responsive: true,
                        legend: {
                            position: 'top',
                        },
                        title: {
                            display: true,
                            text: "REKAP LUASAN LAHAN PER TAHUN (m2)"
                        }
                    }
                });
            }
        });

        $('#btn-filterlahan').click(function () {
            tahunawal = $('#tahunawallahan').val();
            tahunakhir = $('#tahunakhirlahan').val();
            if(tahunakhir < tahunawal){
                alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
            }else{
                setGrafik(tahunawal, tahunakhir);
            }
        });
    });

    function setGrafik(thn_awal, thn_akhir) {
        var ctx = document.getElementById("chart-lahan").getContext("2d");
        var url = "<?php echo e(url('rekapitulasi/getRekapLahanTahun/')); ?>"+"/"+ thn_awal + "/" + thn_akhir;
        $.ajax({
            url: url,
            type: 'post',
            data: {
                "_token": "<?php echo e(csrf_token()); ?>"
            },
            dataType: 'json',
            success: function (datas) {
                //console.log(data);
                barChartlahan.destroy();
                var barChartData = {
                    labels: datas['tahun'],
                    datasets: [{
                            label: 'Kolam',
                            backgroundColor: "rgba(202, 48, 6, 1)",
                            data: datas['kolam']
                    },{
                            label: 'Tambak',
                            backgroundColor: "rgba(232, 183, 48, 1)",
                            data: datas['tambak']
                    },{
                            label: 'Sawah Tambak',
                            backgroundColor: "rgba(61, 232, 48, 1)",
                            data: datas['sawah']
                    },{
                            label: 'Kerambah Jaring Apung',
                            backgroundColor: "rgba(48, 232, 198, 1)",
                            data: datas['kerambah']
                    },{
                            label: 'Kerambah Jaring Tancap',
                            backgroundColor: "rgba(148, 111, 198, 1)",
                            data: datas['tancap']
                    }]
                };
                barChartlahan = new Chart(ctx, {
                    type: 'bar',
                    data: barChartData,
                    options: {
                        responsive: true,
                        legend: {
                            position: 'top',
                        },
                        title: {
                            display: true,
                            text: 'REKAP LUASAN LAHAN PER TAHUN'
                        }
                    }
                });
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout_depan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/perikanan/resources/views/depan/grafik_luasan.blade.php ENDPATH**/ ?>