
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.4.0/dist/leaflet.css"
   integrity="sha512-puBpdR0798OZvTTbP4A8Ix/l+A4dHDD0DGqYW6RQ+9jxkRFclaxxQb/SJAWZfWAkuyeQUytO7+7N4QKrDh+drA=="
   crossorigin=""/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('konten'); ?>
<section class="portfolio-item-details">
    <div class="col-lg-12">
        <h2><center>Peta Potensi Budidaya Per Desa</center></h2>
    </div>
    <div id="mapL" style="height: 100vh; width: 100%;"></div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://unpkg.com/leaflet@1.4.0/dist/leaflet.js"
   integrity="sha512-QVftwZFqvtRNi0ZyCtsznlKSWOStnDORoefr1enyq5mVL4tmKB3S/EnC3rRJcxCPavG10IcrVGSmPh6Qw5lwrg=="
   crossorigin=""></script>
    <script>
        var batasdesa;
        var datades;

        $( document ).ready(function() {
            var url = "<?php echo e(url('/peta/getDesaAll')); ?>";
            $.ajax({
                url: url,
                type: 'post',
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>"
                },
                dataType: 'json',
                success: function (data) {
                    datades=data;
                }
            });
        });

        function style(feature) {
            return {
                fillColor: 'blue', 
                fillOpacity: 0.5,  
                weight: 2,
                opacity: 1,
                color: '#ffffff',
                dashArray: '3'
            };
        }
        var highlight = {
            'fillColor': 'green',
            'weight': 2,
            'opacity': 1
        };
        var popupOptions ={
            'maxWidth': '400',
            'className' : 'infowindow'
        };

        var mapL = L.map('mapL', {
            center: [-7.118694, 112.411955],
            zoom: 10
        });

        var imageUrl = 'http://perikanan.peganden.id/tiled/map/{z}/{x}/{y}.png';
        var citra = L.tileLayer(imageUrl, {maxZoom: 22}).addTo(mapL);
        var googleSat = L.tileLayer('http://{s}.google.com/vt/lyrs=s&x={x}&y={y}&z={z}',{
            maxZoom: 20,
            subdomains:['mt0','mt1','mt2','mt3']
        });

        let batas = L.layerGroup().addTo( mapL );

        $.ajax({
            beforeSend: function (xhr) {
                if (xhr && xhr.overrideMimeType) {
                xhr.overrideMimeType('application/json;charset=utf-8');
                }
            },
            dataType: "json",
            url: "<?php echo e(url('tiled/desa.geojson')); ?>",
            success: function(data) {
                batasdesa = L.geoJSON(data, {
                    onEachFeature: addMyBatas,
                    style: style
                }).bindPopup(function (layer) {
                        var id = parseInt(layer.feature.properties.Name);
                        return  "<table class='infowindow'>" +
                                "<tr><td class='judul' colspan='4' style='text-align:center;'><h5><b> DESA " + datades[id]['NAMA_DESA'] + "</b></h5></td></tr>" +
                                "<tr style='border-bottom: 1px solid black;'><td colspan='4' style='text-align:center;'><h5><b>KECAMATAN " + datades[id]['NAMA_KECAMATAN'] + "</b></h5></td></tr>" +
                                "<tr><td>Lahan</td><td>Kolam</td><td><b>:</b></td><td style='text-align:right;'><b>" + datades[id]['LAHAN'][1] + " m&sup2;</b></td></tr>" +
                                "<tr><td></td><td>Tambak</td><td><b>:</b></td><td style='text-align:right;'><b>" + datades[id]['LAHAN'][2] + " m&sup2;</b></td></tr>" +
                                "<tr><td></td><td>Sawah Tambak</td><td><b>:</b></td><td style='text-align:right;'><b>" + datades[id]['LAHAN'][3] + " m&sup2;</b></td></tr>" +
                                "<tr style='border-bottom: 1px solid black;'><td></td><td>Kerambah Jaring Apung</td><td><b>:</b></td><td style='text-align:right;'><b>" + datades[id]['LAHAN'][4] + " m&sup2;</b></td></tr>" +
                                "<tr><td>RTP</td><td>Kolam</td><td><b>:</b></td><td style='text-align:right;'><b>" + datades[id]['RTP'][1] + "</b></td></tr>" +
                                "<tr><td></td><td>Tambak</td><td><b>:</b></td><td style='text-align:right;'><b>" + datades[id]['RTP'][2] + "</b></td></tr>" +
                                "<tr><td></td><td>Sawah Tambak</td><td><b>:</b></td><td style='text-align:right;'><b>" + datades[id]['RTP'][3] + "</b></td></tr>" +
                                "<tr style='border-bottom: 1px solid black;'><td></td><td>Kerambah Jaring Apung</td><td><b>:</b></td><td style='text-align:right;'><b>" + datades[id]['RTP'][4] + "</b></td></tr>" +
                                "<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>" +
                                "</table>";
                }, popupOptions);
                batasdesa.addTo(mapL);
            }
        });

        function addMyBatas( feature, layer ){
            layer.on("click", function (e) { 
                batasdesa.setStyle(style);
                layer.setStyle(highlight);
            }); 
            batas.addLayer( layer );
        }
    
        var basemapControl = {
            "Map": citra,
            "Satelit": googleSat
        }
        var layerControl = {
            
        }
        L.control.layers(basemapControl,layerControl).addTo(mapL);
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout_depan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/perikanan/resources/views/depan/peta_desa.blade.php ENDPATH**/ ?>