
<?php $__env->startSection('konten'); ?>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <hr class="no-top-margin" />
        </div>
    </div>	
</div>
<div class="col-lg-12">
    <h2><center>Grafik Rekapitulasi Produksi Ikan Pertahun</center></h2>
</div>
<br><br>
<section class="portfolio-widget">
	
	<div class="container">
		<div class="row">
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Awal</label>
                    <div>
                        <select class="form-control" name="t_awal" id="tahunawal">
                            <?php for($i = 2014; $i <= Date('Y'); $i++): ?>
                            <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Akhir</label>
                    <div>
                        <select class="form-control" name="t_akhir" id="tahunakhir">
                            <?php for($i = 2014; $i <= Date('Y'); $i++): ?>
                            <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tampilkan</label>
                    <div>
                        <button id="btn-filterikan" class="btn btn-primary"><i class="entypo-search"></i></button>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
		
            <div class="col-sm-12">
                <canvas id="chart-rekap"></canvas>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('chartjs/dist/Chart.js')); ?>"></script>

<script>
    var barChart;
    $(document).ready(function () {
        var d = new Date();
        $('#tahunawal').val(d.getUTCFullYear());
        $('#tahunakhir').val(d.getUTCFullYear());
        var tahunawal = $('#tahunawal').val();
        var tahunakhir = $('#tahunakhir').val();
        var ctx = document.getElementById("chart-rekap").getContext("2d");
        //var barChart;
        var url = "<?php echo e(url('rekapitulasi/getRekapIkanTahun/')); ?>"+"/"+ tahunawal + "/" + tahunakhir;
        $.ajax({
            url: url,
            type: 'post',
            data: {
                "_token": "<?php echo e(csrf_token()); ?>"
            },
            dataType: 'json',
            success: function (data) {
                //console.log(data);
                var barChartData = {
                    labels: data['tahun'],
                    datasets: data['dataset']
                };
                barChart = new Chart(ctx, {
                    type: 'bar',
                    data: barChartData,
                    options: {
                        responsive: true,
                        legend: {
                            position: 'top'
                        },
                        title: {
                            display: true,
                            text: 'REKAP PRODUKSI IKAN PER TAHUN (Kg)'
                        }
                    }
                });
            }
        });
        $('#btn-filterikan').click(function () {
            tahunawal = $('#tahunawal').val();
            tahunakhir = $('#tahunakhir').val();
            if(tahunakhir < tahunawal){
                alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
            }else{
                setGrafikkan(tahunawal, tahunakhir);
            }
        });
    });
    function setGrafikkan(thn_awal, thn_akhir) {
        var ctx = document.getElementById("chart-rekap").getContext("2d");
        var url = "<?php echo e(url('rekapitulasi/getRekapIkanTahun/')); ?>"+"/"+ thn_awal + "/" + thn_akhir;
        $.ajax({
            url: url,
            type: 'post',
            data: {
                "_token": "<?php echo e(csrf_token()); ?>"
            },
            dataType: 'json',
            success: function (data) {
                //console.log(data);
                barChart.destroy();
                var barChartData = {
                    labels: data['tahun'],
                    datasets: data['dataset']
                };
                barChart = new Chart(ctx, {
                    type: 'bar',
                    data: barChartData,
                    options: {
                        responsive: true,
                        legend: {
                            position: 'top',
                        },
                        title: {
                            display: true,
                            text: 'REKAP PRODUKSI IKAN PER TAHUN'
                        }
                    }
                });
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout_depan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/perikanan/resources/views/depan/grafik_tahun.blade.php ENDPATH**/ ?>