
<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/js/datatables/datatables.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/js/select2/select2-bootstrap.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/js/select2/select2.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('konten'); ?>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <hr class="no-top-margin" />
        </div>
    </div>	
</div>
<div class="row">
    <div class="col-lg-12">
        <h2><center>Tabulasi Produksi Per Tahun</center></h2>
    </div>
</div>
<section class="portfolio-widget">
	
	<div class="container">
		<div class="row">
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Awal</label>
                    <div>
                        <select class="form-control" name="t_awal" id="t_awal">
                            <?php for($i = 2014; $i <= Date('Y'); $i++): ?>
                                <option value="<?php echo e($i); ?>" <?php if($i == $thn_awal): ?> selected <?php endif; ?>><?php echo e($i); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Akhir</label>
                    <div>
                        <select class="form-control" name="t_akhir" id="t_akhir">
                            <?php for($i = 2014; $i <= Date('Y'); $i++): ?>
                                <option value="<?php echo e($i); ?>" <?php if($i == $thn_akhir): ?> selected <?php endif; ?>><?php echo e($i); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tampilkan</label>
                    <div>
                        <button onclick="getUrl();" class="btn btn-primary"><i class="entypo-search"></i></button>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
		
            <div class="col-sm-12">
                <table class="table table-bordered datatable" id="table-1">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Jenis Ikan</th>
                            <?php for($i = $thn_awal; $i <= $thn_akhir; $i++): ?>
                                <th><?php echo e($i); ?> (Kg)</th>
                            <?php endfor; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $no=1;
                        ?>
                        <?php $__currentLoopData = $data_rekap; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rkp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($no); ?></td>
                                <td><?php echo e($rkp['nama_ikan']); ?></td>
                                <?php $__currentLoopData = $rkp['rtp']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td style="text-align:right;"><?php echo e(number_format($qty,0,",",".")); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        <?php
                            $no++;
                        ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/js/datatables/datatables.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/select2/select2.min.js')); ?>"></script>
<script type="text/javascript">
    jQuery( document ).ready( function( $ ) {
        var $table1 = jQuery( '#table-1' );
        
        // Initialize DataTable
        $table1.DataTable( {
            "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
            "bStateSave": true
        });
        
        // Initalize Select Dropdown after DataTables is created
        $table1.closest( '.dataTables_wrapper' ).find( 'select' ).select2( {
            minimumResultsForSearch: -1
        });
    } );
</script>

<script>
    function getUrl(){
        var awl, akhr, url;
        awl = $('#t_awal').val();
        akhr = $('#t_akhir').val();
        if(akhr < awl){
            alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
        }else{
            url = "<?php echo e(url('tabulasi/tahun/')); ?>/"+awl+"/"+akhr;
            window.location.href = url;
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout_depan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/perikanan/resources/views/depan/tabulasi_tahun.blade.php ENDPATH**/ ?>