<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/cleareverything', function () {
    $cache = \Artisan::call('cache:clear');
    echo "Cache cleared<br>";

    $config = \Artisan::call('config:cache');
    echo "Config cleared<br>";

    $view = Artisan::call('view:clear');
    echo "View cleared<br>";

    $route = Artisan::call('route:clear');
    echo "Route cleared<br>";
});

Route::get('/', function () {
    $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
    return view('welcome')->with('berita', $berita);
});

Route::get('/peta/kecamatan', 'DepanController@Vpeta_kecamatan');
Route::get('/peta/desa', 'DepanController@Vpeta_desa');
Route::post('/peta/getKecamatanAll', 'DepanController@Vpeta_getKecamatanAll');
Route::post('/peta/getDesaAll', 'DepanController@Vpeta_getDesaAll');

Route::get('/tabulasi/tahun/{awl}/{akhr}', 'DepanController@Vtabulasi_tahun');
Route::get('/tabulasi/rtp/{awl}/{akhr}/{lhn}', 'DepanController@Vtabulasi_rtp');

Route::get('/grafik/tahun', 'DepanController@Vgrafik_tahun');
Route::get('/grafik/luasan', 'DepanController@Vgrafik_luasan');

Route::post('/rekapitulasi/getRekapIkanTahun/{awl}/{akhr}', 'DepanController@getRekapIkanTahun');
Route::post('/rekapitulasi/getRekapLahanTahun/{awl}/{akhr}', 'DepanController@getRekapLahanTahun');

Route::get('/berita_utama', 'DepanController@Vberita');
Route::get('/baca_berita_utama/{id}', 'DepanController@Vbaca_berita');

Route::get('/meta_data', 'DepanController@Vmeta');

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');


// data
Route::get('/data', 'DataController@index');
Route::get('/data/detail/{id_desa}/{tahun}/{jns_lahan}', 'DataController@detail');
Route::post('/saveReport', 'DataController@saveReport');
Route::post('/data/download_form', 'DataController@download_form');
Route::post('/data/upload', 'DataController@upload_form');
Route::get('/export_detail/{desa}/{lahan}/{tahun}', 'DataController@export_detail');
Route::post('/data_detail/upload', 'DataController@upload_detail_form');
Route::post('/detail/update_rtp', 'DataController@update_rtp');



// harga
Route::get('/harga/{kd}/{th}', 'DataController@harga');
Route::post('/saveHarga', 'DataController@saveHarga');
Route::get('/harga/CetakHargaTotalIkan/{kd}/{th}', 'DataController@cetakTotalIkan');

// rekap
Route::get('/rekap/desa/{kecamatan}/{jenis_lahan}/{tahun}/{bulan}', 'RekapController@desa');
Route::get('/rekap/kecamatan/{jenis_lahan}/{tahun}/{bulan}', 'RekapController@kecamatan');
Route::get('/rekap/tahun', 'RekapController@tahun');
Route::get('/rekap/rtp/{awl}/{akhr}/{lhn}', 'RekapController@rtp');
Route::get('/rekap/luas_lahan', 'RekapController@luas_lahan');
Route::get('/rekap/grafik/dataikan', 'RekapController@dataikan');

Route::get('/rekap/CetakRekapDesaTahun/{kec}/{thn}/{lhn}/{bln}', 'RekapController@cetakrekapdesatahun');
Route::get('/rekap/CetakRekapKecamatanTahun/{thn}/{lhn}/{bln}', 'RekapController@cetakrekapkecamatantahun');
Route::get('/rekap/CetakRekapRTP/{awl}/{akhr}/{lhn}', 'RekapController@cetakrekaprtp');
// Kecamatan
Route::get('/pengaturan/kecamatan', 'PengaturanController@kecamatan');
Route::post('/pengaturan/add_kecamatan', 'PengaturanController@store_kecamatan');
Route::get('/pengaturan/get_kecamatan/{id}', 'PengaturanController@get_kecamatan');
Route::post('/pengaturan/update_kecamatan', 'PengaturanController@update_kecamatan');
Route::get('/pengaturan/hapus_kecamatan/{id}', 'PengaturanController@hapus_kecamatan');

// Desa
Route::get('/pengaturan/desa', 'PengaturanController@desa');
Route::post('/pengaturan/add_desa', 'PengaturanController@store_desa');
Route::get('/pengaturan/get_desa/{id}', 'PengaturanController@get_desa');
Route::post('/pengaturan/update_desa', 'PengaturanController@update_desa');
Route::get('/pengaturan/hapus_desa/{id}', 'PengaturanController@hapus_desa');

// Jenis Ikan
Route::get('/pengaturan/jenis_ikan', 'PengaturanController@jenis_ikan');
Route::post('/pengaturan/add_ikan', 'PengaturanController@store_ikan');
Route::get('/pengaturan/get_ikan/{id}', 'PengaturanController@get_ikan');
Route::post('/pengaturan/update_ikan', 'PengaturanController@update_ikan');
Route::get('/pengaturan/hapus_ikan/{id}', 'PengaturanController@hapus_ikan');

// Berita
Route::get('/berita', 'BeritaController@index');
Route::get('/berita/tulis', 'BeritaController@tulis');
Route::post('/berita/add', 'BeritaController@store_berita');
Route::get('/berita/edit/{id}', 'BeritaController@edit_berita');
Route::post('/berita/update', 'BeritaController@update_berita');
Route::get('/berita/lihat/{id}', 'BeritaController@lihat_berita');
Route::get('/berita/hapus/{id}', 'BeritaController@hapus_berita');



// Route::get('/store_user', 'PengaturanController@store_user');