@extends('layouts.layout')
@section('css')
	<link rel="stylesheet" href="{{ asset('assets/js/datatables/datatables.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/js/select2/select2-bootstrap.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/js/select2/select2.css') }}">
    <style>
        .flex-container {
            display: flex;
        }

        .flex-container > div {
            padding: 5px;
            text-align: center;
        }
    </style>
@endsection

@section('konten')
<ol class="breadcrumb bc-3" >
    <li>
        <a href="{{ url('/home') }}"><i class="fa-home"></i>Rekapitulasi</a>
    </li>
    <li class="active">
        <strong>Rekapitulasi Produksi Ikan Per Tahun</strong>
    </li>
</ol>
    <div class="flex-container">
        <div>Tahun Awal</div>
        <div>
            <select class="form-control" name="t_awal" id="tahunawal">
                @for ($i = 2014; $i <= Auth::user()->tahun_data; $i++)
                <option value="{{ $i }}">{{ $i }}</option>
                @endfor
            </select>
        </div>
        <div>Tahun Akhir</div>
        <div>
            <select class="form-control" name="t_akhir" id="tahunakhir">
                @for ($i = 2014; $i <= Auth::user()->tahun_data; $i++)
                <option value="{{ $i }}">{{ $i }}</option>
                @endfor
            </select>
        </div>
        <div>
            <a  id="cari" type="button" class="btn btn-green">
                <i class="entypo-search"></i>
            </a>
        </div>
    </div>
    <!--<canvas id="myChart" width="400" height="200"></canvas>-->
    <canvas id="chart-rekap"></canvas>

    <div class="row">
        <center>
            <button type="button" id="btn_cetak" class="btn btn-success"> <i class="entypo-print"></i> Cetak</button>
        </center>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/datatables/datatables.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.min.js') }}"></script>
    
    <!--<script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.3/dist/Chart.min.js"></script>-->
    <script src="{{ asset('chartjs/dist/Chart.js') }}"></script>
    <script>
        var barChart;
        $(document).ready(function () {
            var d = "{{ Auth::user()->tahun_data }}";
            $('#tahunawal').val(d);
            $('#tahunakhir').val(d);
            var tahunawal = $('#tahunawal').val();
            var tahunakhir = $('#tahunakhir').val();
            var ctx = document.getElementById("chart-rekap").getContext("2d");
            //var barChart;
            var url = "{{ url('rekapitulasi/getRekapIkanTahun/') }}"+"/"+ tahunawal + "/" + tahunakhir;
            $.ajax({
                url: url,
                type: 'post',
                data: {
                    "_token": "{{ csrf_token() }}"
                },
                dataType: 'json',
                success: function (data) {
                    //console.log(data);
                    var barChartData = {
                        labels: data['tahun'],
                        datasets: data['dataset']
                    };
                    barChart = new Chart(ctx, {
                        type: 'bar',
                        data: barChartData,
                        options: {
                            responsive: true,
                            legend: {
                                position: 'top'
                            },
                            title: {
                                display: true,
                                text: 'REKAP PRODUKSI IKAN PER TAHUN (Kg)'
                            }
                        }
                    });
                }
            });
            
            $('#cari').click(function () {
                tahunawal = $('#tahunawal').val();
                tahunakhir = $('#tahunakhir').val();
                if(tahunakhir < tahunawal){
                    alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
                }else{
                    setGrafikkan(tahunawal, tahunakhir);
                }
            });
        });
        
        function setGrafikkan(thn_awal, thn_akhir) {
            var ctx = document.getElementById("chart-rekap").getContext("2d");
            var url = "{{ url('rekapitulasi/getRekapIkanTahun/') }}"+"/"+ thn_awal + "/" + thn_akhir;
            $.ajax({
                url: url,
                type: 'post',
                data: {
                    "_token": "{{ csrf_token() }}"
                },
                dataType: 'json',
                success: function (data) {
                    //console.log(data);
                    barChart.destroy();
                    var barChartData = {
                        labels: data['tahun'],
                        datasets: data['dataset']
                    };
                    barChart = new Chart(ctx, {
                        type: 'bar',
                        data: barChartData,
                        options: {
                            responsive: true,
                            legend: {
                                position: 'top',
                            },
                            title: {
                                display: true,
                                text: 'REKAP PRODUKSI IKAN PER TAHUN'
                            }
                        }
                    });
                }
            });
        }
    </script>
    <script>
        // var ikan = $.ajax({type: "GET", url: {!! json_encode(url('/rekap/grafik/dataikan')) !!}, async: false}).responseJSON;
        // var ctx = document.getElementById('myChart').getContext('2d');
        // var myChart = new Chart(ctx, {
        //     type: 'bar',
        //     data: {
        //         labels: ikan,
        //         datasets: [{
        //             label: ['sapi', 'ikan'],
        //             data: [12, 19, 3, 5, 2, 3,2,3,4,5],
        //             backgroundColor: [
        //                 'rgba(255, 99, 132, 0.2)',
        //                 'rgba(54, 162, 235, 0.2)',
        //                 'rgba(255, 206, 86, 0.2)',
        //                 'rgba(75, 192, 192, 0.2)',
        //                 'rgba(153, 102, 255, 0.2)',
        //                 'rgba(255, 159, 64, 0.2)'
        //             ],
        //             borderColor: [
        //                 'rgba(255, 99, 132, 1)',
        //                 'rgba(54, 162, 235, 1)',
        //                 'rgba(255, 206, 86, 1)',
        //                 'rgba(75, 192, 192, 1)',
        //                 'rgba(153, 102, 255, 1)',
        //                 'rgba(255, 159, 64, 1)'
        //             ],
        //             borderWidth: 1
        //         }]
        //     },
        //     options: {
        //         scales: {
        //             yAxes: [{
        //                 ticks: {
        //                     beginAtZero: true
        //                 }
        //             }]
        //         }
        //     }
        // });
    </script>
    <script>
        $('#btn_cetak').click(function(){
            var url_base64jp = document.getElementById("chart-rekap").toDataURL("image/jpg");
            var myWindow = window.open(url_base64jp, '_blank');
        });
    </script>
@endsection
