@extends('layouts.layout')

@section('konten')
<ol class="breadcrumb bc-3" >
    <li>
        <a href="{{ url('/home') }}"><i class="fa-home"></i>Rekapitulasi</a>
    </li>
    <li class="active">
        <strong>RTP</strong>
    </li>
</ol>

<div class="row">
    <div class="col-md-3">
        <div class="form-group">
            <label class="control-label">Tahun Awal</label>
            <div>
                <select class="form-control" name="t_awal" id="t_awal">
                    @for ($i = 2014; $i <= Auth::user()->tahun_data; $i++)
                        <option value="{{ $i }}" @if($i == $thn_awal) selected @endif>{{ $i }}</option>
                    @endfor
                </select>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group">
            <label class="control-label">Tahun Akhir</label>
            <div>
                <select class="form-control" name="t_akhir" id="t_akhir">
                    @for ($i = 2014; $i <= Auth::user()->tahun_data; $i++)
                        <option value="{{ $i }}" @if($i == $thn_akhir) selected @endif>{{ $i }}</option>
                    @endfor
                </select>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group">
            <label class="control-label">Jenis Lahan</label>
            <div>
                <select class="form-control" name="j_lahan" id="j_lahan">
                    <option value="0" @if($lhn == 0) selected @endif>Semua Jenis Lahan</option>
                    @foreach($lahan as $value)
                        <option value="{{ $value->id_lahan }}" @if($lhn == $value->id_lahan) selected @endif>{{ $value->nama_lahan }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group">
            <label class="control-label">Tampilkan</label>
            <div>
                <button onclick="getUrl();" class="btn btn-primary"><i class="entypo-search"></i></button>
            </div>
        </div>
    </div>
</div>
<div class="row">
		
    <div class="col-sm-12">
        <table class="table table-bordered datatable" id="table-1">
            <thead>
                <tr>
                    <th style="font-weight:bold">No.</th>
                    <th style="font-weight:bold">Desa</th>
                    @for ($i = $thn_awal; $i <= $thn_akhir; $i++)
                        <th style="font-weight:bold">{{ $i }}</th>
                    @endfor
                </tr>
            </thead>
            <tbody>
                @php
                    $no=1;
                @endphp
                @foreach ($data_rekap as $value)
                    <tr>
                        <td>{{ $no }}</td>
                        <td>{{ $value['nama_desa'] }}</td>
                        @foreach ($value['rtp'] as $qty)
                        <td>{{ $qty }}</td>
                        @endforeach
                    </tr>
                    @php
                        $no++;
                    @endphp
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<div class="flex-container">
<div class="row">
    <button type="button" id="btn_cetak" class="btn btn-success"> <i class="entypo-print"></i> Cetak</button>
</div>
</div>

@endsection
@section('js')
    <script type="text/javascript">
        
        $('#btn_cetak').click(function(){
            var t_awl = $('#t_awal').val();
            var t_akhir = $('#t_akhir').val();
            var lhn =$('#j_lahan').val();
            if(t_akhir < t_awl){
                alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
            }else{
                window.location = "{{ url('rekap/CetakRekapRTP') }}/"+t_awl+"/"+t_akhir+"/"+lhn;
            }
        });
    </script>
    <script>
        function getUrl(){
            var awl, akhr, lhn, url;
            awl = $('#t_awal').val();
            akhr = $('#t_akhir').val();
            lhn = $('#j_lahan').val();
            if(akhr < awl){
                alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
            }else{
                url = "{{ url('rekap/rtp/') }}/"+awl+"/"+akhr+"/"+lhn;
                window.location.href = url;
            }
        }
    </script>
@endsection
