@extends('layouts.layout')

@section('konten')
<ol class="breadcrumb bc-3" >
    <li>
        <a href="{{ url('/home') }}"><i class="fa-home"></i>Rekapitulasi</a>
    </li>
    <li class="active">
        <strong>Luasan Lahan</strong>
    </li>
</ol>

<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <label class="control-label">Tahun Awal</label>
            <div>
                <select class="form-control" name="t_awal" id="tahunawallahan">
                    @for ($i = 2014; $i <= Auth::user()->tahun_data; $i++)
                    <option value="{{ $i }}">{{ $i }}</option>
                    @endfor
                </select>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label class="control-label">Tahun Akhir</label>
            <div>
                <select class="form-control" name="t_akhir" id="tahunakhirlahan">
                    @for ($i = 2014; $i <= Auth::user()->tahun_data; $i++)
                    <option value="{{ $i }}">{{ $i }}</option>
                    @endfor
                </select>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label class="control-label">Tampilkan</label>
            <div>
                <button id="btn-filterlahan" class="btn btn-primary"><i class="entypo-search"></i></button>
            </div>
        </div>
    </div>
</div>
<div class="row">

    <div class="col-md-12">
        <canvas id="chart-lahan"></canvas>
    </div>
</div>
<div class="row">
    <center>
        <button type="button" id="btn_cetak" class="btn btn-success"> <i class="entypo-print"></i> Cetak</button>
    </center>
</div>
@endsection
@section('js')
<script src="{{ asset('chartjs/dist/Chart.js') }}"></script>
<script>
    var barChartlahan;
    $(document).ready(function () {
        var d = "{{ Auth::user()->tahun_data }}";
        $('#tahunawallahan').val(d);
        $('#tahunakhirlahan').val(d);
        var tahunawal = $('#tahunawallahan').val();
        var tahunakhir = $('#tahunakhirlahan').val();
        var ctx = document.getElementById("chart-lahan").getContext("2d");
        //var barChart;
        var url = "{{ url('rekapitulasi/getRekapLahanTahun/') }}"+"/"+ tahunawal + "/" + tahunakhir;
        $.ajax({
            url: url,
            type: 'post',
            data: {
                "_token": "{{ csrf_token() }}"
            },
            dataType: 'json',
            success: function (datas) {
                //console.log(data);
                var barChartData = {
                    labels: datas['tahun'],
                    datasets: [{
                            label: 'Kolam',
                            backgroundColor: "rgba(202, 48, 6, 1)",
                            data: datas['kolam']
                    },{
                            label: 'Tambak',
                            backgroundColor: "rgba(232, 183, 48, 1)",
                            data: datas['tambak']
                    },{
                            label: 'Sawah Tambak',
                            backgroundColor: "rgba(61, 232, 48, 1)",
                            data: datas['sawah']
                    },{
                            label: 'Kerambah Jaring Apung',
                            backgroundColor: "rgba(48, 232, 198, 1)",
                            data: datas['kerambah']
                    },{
                            label: 'Kerambah Jaring Tancap',
                            backgroundColor: "rgba(148, 111, 198, 1)",
                            data: datas['tancap']
                    }]
                };
                barChartlahan = new Chart(ctx, {
                    type: 'bar',
                    data: barChartData,
                    options: {
                        responsive: true,
                        legend: {
                            position: 'top',
                        },
                        title: {
                            display: true,
                            text: "REKAP LUASAN LAHAN PER TAHUN (m2)"
                        }
                    }
                });
            }
        });

        $('#btn-filterlahan').click(function () {
            tahunawal = $('#tahunawallahan').val();
            tahunakhir = $('#tahunakhirlahan').val();
            if(tahunakhir < tahunawal){
                alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
            }else{
                setGrafik(tahunawal, tahunakhir);
            }
        });
    });

    function setGrafik(thn_awal, thn_akhir) {
        var ctx = document.getElementById("chart-lahan").getContext("2d");
        var url = "{{ url('rekapitulasi/getRekapLahanTahun/') }}"+"/"+ thn_awal + "/" + thn_akhir;
        $.ajax({
            url: url,
            type: 'post',
            data: {
                "_token": "{{ csrf_token() }}"
            },
            dataType: 'json',
            success: function (datas) {
                //console.log(data);
                barChartlahan.destroy();
                var barChartData = {
                    labels: datas['tahun'],
                    datasets: [{
                            label: 'Kolam',
                            backgroundColor: "rgba(202, 48, 6, 1)",
                            data: datas['kolam']
                    },{
                            label: 'Tambak',
                            backgroundColor: "rgba(232, 183, 48, 1)",
                            data: datas['tambak']
                    },{
                            label: 'Sawah Tambak',
                            backgroundColor: "rgba(61, 232, 48, 1)",
                            data: datas['sawah']
                    },{
                            label: 'Kerambah Jaring Apung',
                            backgroundColor: "rgba(48, 232, 198, 1)",
                            data: datas['kerambah']
                    },{
                            label: 'Kerambah Jaring Tancap',
                            backgroundColor: "rgba(148, 111, 198, 1)",
                            data: datas['tancap']
                    }]
                };
                barChartlahan = new Chart(ctx, {
                    type: 'bar',
                    data: barChartData,
                    options: {
                        responsive: true,
                        legend: {
                            position: 'top',
                        },
                        title: {
                            display: true,
                            text: 'REKAP LUASAN LAHAN PER TAHUN'
                        }
                    }
                });
            }
        });
    }
</script>
<script>
    $('#btn_cetak').click(function(){
        var url_base64jp = document.getElementById("chart-lahan").toDataURL("image/jpg");
        var myWindow = window.open(url_base64jp, '_blank');
    });
</script>
@endsection
