@extends('layouts.layout')
@section('css')
	<link rel="stylesheet" href="{{ asset('assets/js/datatables/datatables.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/js/select2/select2-bootstrap.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/js/select2/select2.css') }}">
    <style>
        .flex-container {
            display: flex;
        }

        .flex-container > div {
            padding: 5px;
            flex: 1;
            text-align: center;
        }
    </style>
@endsection

@section('konten')
<ol class="breadcrumb bc-3" >
    <li>
        <a href="{{ url('/home') }}"><i class="fa-home"></i>Rekapitulasi</a>
    </li>
    <li class="active">
        <strong>Rekapitulasi Produksi Ikan Per Desa</strong>
    </li>
</ol>
    <div class="flex-container">
        <div>Kecamatan</div>
        <div>
            <select id="kecamatan" class="form-control">
                <option value="0">-- Semua Kecamatan -- </option>
                @foreach ($kec as $k)
                    <option value="{{ $k->id_kecamatan }}" @if ($kecamatan == $k->id_kecamatan) selected @endif>{{ $k->nama_kecamatan }}</option>
                @endforeach
            </select>
        </div>
        <div>Jenis Lahan</div>
        <div>
            <select id="jenislahan" class="form-control">
                <option value="0">Jenis Lahan</option>
                @foreach ($jl as $l)
                    <option value="{{ $l->id_lahan }}" @if ($jenis_lahan == $l->id_lahan) selected @endif>{{ $l->nama_lahan }}</option>
                @endforeach
            </select>
        </div>
        <div>Bulan</div>
        <div>
            <select id="bulan" class="form-control">
                <option value="0" @if ($bulan == 0) selected @endif>Satu Tahun</option>
                <option value="13" @if ($bulan == 13) selected @endif>Triwulan 1 (Jan-Mar)</option>
                <option value="14" @if ($bulan == 14) selected @endif>Triwulan 2 (Apr-Jun)</option>
                <option value="15" @if ($bulan == 15) selected @endif>Triwulan 3 (Jul-Sep)</option>
                <option value="16" @if ($bulan == 16) selected @endif>Triwulan 4 (Okt-Des)</option>
                <option value="1" @if ($bulan == 1) selected @endif>Januari</option>
                <option value="2" @if ($bulan == 2) selected @endif>Februari</option>
                <option value="3" @if ($bulan == 3) selected @endif>Maret</option>
                <option value="4" @if ($bulan == 4) selected @endif>April</option>
                <option value="5" @if ($bulan == 5) selected @endif>Mei</option>
                <option value="6" @if ($bulan == 6) selected @endif>Juni</option>
                <option value="7" @if ($bulan == 7) selected @endif>Juli</option>
                <option value="8" @if ($bulan == 8) selected @endif>Agustus</option>
                <option value="9" @if ($bulan == 9) selected @endif>September</option>
                <option value="10" @if ($bulan == 10) selected @endif>Oktober</option>
                <option value="11" @if ($bulan == 11) selected @endif>November</option>
                <option value="12" @if ($bulan == 12) selected @endif>Desember</option>
            </select>
        </div>
        <div>Tahun</div>
        <div>
            <select id="tahun" class="form-control">
                <option>{{ Auth::user()->tahun_data }}</option>
            </select>
        </div>
        
    </div>
    <div class="row">
		<div class="col-md-12" style="overflow: scroll;">
            <table class="table table-bordered datatable" id="table-1">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Desa</th>
                        <th>RTP</th>
                        <th>Luasan</th>
                        @foreach ($ikan as $ik)
                            <th>{{ $ik->nama_ikan }}</th>
                        @endforeach
                        <th style="font-weight:bold; background-color: #dcdedc;">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalrtp =0;
                        $totallahan =0;
                        $no = 1;
                        $ttl = 0;
                    @endphp
                    @foreach ($data as $dt)
                    <tr>
                        <td>{{ $no }}</td>
                        <td>{{ $dt['nama_desa'] }}</td>
                        <td>{{ $dt['rtp'] }}</td>
                        <td>{{ $dt['lahan'] }}</td>
                        @php
                        $ttl_ikn = 0;
                        @endphp
                        @foreach ($dt['ikan'] as $ikan)
                            <td>{{ $ikan }}</td>
                            @php
                                $ttl_ikn+=$ikan;
                            @endphp
                        @endforeach
                        <td style="font-weight:bold; background-color: #dcdedc;">{{ $ttl_ikn }}</td>
                    </tr>
                    @php
                        $totalrtp += $dt['rtp'];
                        $totallahan +=$dt['lahan'];
                        $ttl += $ttl_ikn;
                        $no++
                    @endphp
                    @endforeach
                    
                    @php
                    $data_total['totalrtp']=$totalrtp;
                    $data_total['totallahan']=$totallahan;
                    @endphp
                    <tr style="font-weight:bold; background-color: #dcdedc;">
                        <td>{{ $no }}</td>
                        <td>{{ $data_total['totale'] }}</td>
                        <td>{{ $data_total['totalrtp'] }}</td>
                        <td>{{ $data_total['totallahan'] }}</td>
                        @foreach ($ikan2 as $ikn)
                            <td>{{ $data_total[$ikn->id_ikan] }}</td>
                        @endforeach
                        <td>{{ $ttl }}</td>
                    </tr>
                </tbody>
            </table>
            <div class="flex-container">
            <div class="row">
                <button type="button" id="btn_cetak" class="btn btn-success"> <i class="entypo-print"></i> Cetak</button>
            </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/datatables/datatables.js') }}"></script>
    <script src="{{ asset('assets/js/select2/select2.min.js') }}"></script>
    <script>
        var kc = {{ $kecamatan }}
        var jl = {{ $jenis_lahan }}
        var th = {{ $tahun }}
        var bl = {{ $bulan }}
        $("#kecamatan").change(function(){
            var k = $(this).val()
            url = "{{ url('rekap/desa/') }}/"+k+"/"+jl+"/"+th+"/"+bl;
            window.location.href = url;
        });
        $("#jenislahan").change(function(){
            var j = $(this).val()
            url = "{{ url('rekap/desa/') }}/"+kc+"/"+j+"/"+th+"/"+bl;
            window.location.href = url;
        });
        $("#bulan").change(function(){
            var b = $(this).val()
            url = "{{ url('rekap/desa/') }}/"+kc+"/"+jl+"/"+th+"/"+b;
            window.location.href = url;
        });
        $("#tahun").change(function(){
            var t = $(this).val()
            url = "{{ url('rekap/desa/') }}/"+kc+"/"+jl+"/"+t+"/"+bl;
            window.location.href = url;
        });
        
        $('#btn_cetak').click(function(){
            var tahun = $('#tahun').val();
            var lah =$('#jenislahan').val();
            var bulan =$('#bulan').val();
            var kecamatan = $('#kecamatan').val();
            window.location = "{{ url('rekap/CetakRekapDesaTahun/') }}/"+kecamatan+'/'+tahun+'/'+lah+'/'+bulan;
        });
    </script>

@endsection
