@extends('layouts.layout')
@section('css')
	<link rel="stylesheet" href="{{ asset('assets/js/datatables/datatables.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/js/select2/select2-bootstrap.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/js/select2/select2.css') }}">
@endsection

@section('konten')
<ol class="breadcrumb bc-3" >
    <li>
        <a href="{{ url('/home') }}"><i class="entypo-home"></i>Beranda</a>
    </li>
    <li class="active">
        <strong>Data Jenis Ikan</strong>
    </li>
</ol>
<table class="table table-bordered datatable" id="table-1">
    <thead>
        <tr>
            <th>No</th>
            <th>Nama Ikan</th>
            <th>Harga</th>
            <th style="text-align: center;">Aksi</th>
        </tr>
    </thead>
    <tbody>
        @php
            $no = 1;
        @endphp
        @foreach ($data as $dt)
        <tr>
            <td>{{ $no }}</td>
            <td>{{ $dt->nama_ikan }}</td>
            <td>{{ 'Rp.'.number_format($dt->harga, 2) }}</td>
            <td style="text-align: center;">
                <div class="btn-group">
                    <button type="button" class="btn btn-gold btn-icon" onclick="edit('{{ $dt->id_ikan }}');">
                        Edit
                        <i class="entypo-pencil"></i>
                    </button>
                    <a href="{{ url('pengaturan/hapus_ikan/'.$dt->id_ikan) }}" type="button" class="btn btn-red btn-icon" onclick="return confirm(' Yakin ingin hapus..?');">
                        Hapus
                        <i class="entypo-trash"></i>
                    </a>
                </div>
            </td>
        </tr>
        @php
            $no++
        @endphp
        @endforeach
    </tbody>
</table>

<div class="modal fade" id="modal-1">
    <div class="modal-dialog">
        <div class="modal-content">                    
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Tambah Jenis Ikan</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="{{ url('pengaturan/add_ikan') }}" class="form-horizontal" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <label for="field-1" class="col-sm-3 control-label">Nama Ikan</label>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="nama" placeholder="Nama Ikan" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="field-1" class="col-sm-3 control-label">Harga ikan</label>
                        <div class="col-sm-5">
                            <input type="number" class="form-control" name="harga" placeholder="Harga" required>
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-red" data-dismiss="modal">Batal</button>
                <button type="submit"  class="btn btn-green">Simpan</button>
            </div>
        </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-edit">
    <div class="modal-dialog">
        <div class="modal-content">                    
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Edit Kecamatan</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="{{ url('pengaturan/update_ikan') }}" class="form-horizontal" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <input type="hidden" id="id_ikan" name="id_ikan">
                    <div class="form-group">
                        <label for="field-1" class="col-sm-3 control-label">Nama Ikan</label>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="nama" id="nama" placeholder="Nama Ikan" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="field-1" class="col-sm-3 control-label">Harga ikan</label>
                        <div class="col-sm-5">
                            <input type="number" class="form-control" name="harga" id="harga" placeholder="Harga" required>
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-red" data-dismiss="modal">Batal</button>
                <button type="submit"  class="btn btn-green">Simpan</button>
            </div>
        </form>
        </div>
    </div>
</div>

@endsection
@section('js')
    <script src="{{ asset('assets/js/datatables/datatables.js') }}"></script>
	<script src="{{ asset('assets/js/select2/select2.min.js') }}"></script>
    <script type="text/javascript">
        $( document ).ready( function( $ ) {
            
            jQuery.noConflict();
            var $table1 = $( '#table-1' );
            
            // Initialize DataTable
            $table1.DataTable( {
                "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                "bStateSave": true,
                "dom": '<"toolbar"><"top"fl>rt<"bottom"ip><"clear">'
            });
            $("div.toolbar").html('<a href="javascript:;" type="button" class="btn btn-green btn-icon" onclick="showModal();">Tambah Jenis Ikan <i class="entypo-list-add"></i></a>');
            // Initalize Select Dropdown after DataTables is created
            $table1.closest( '.dataTables_wrapper' ).find( 'select' ).select2( {
                minimumResultsForSearch: -1
            });
        } );
    </script>

    <script>
        function showModal(){
            $('#modal-1').modal('show');
        }

        function edit(id){
            $.get({!! json_encode(url('/')) !!}+"/pengaturan/get_ikan/" + id , function(data) {
                $('#id_ikan').val(data.id_ikan);
                $('#nama').val(data.nama_ikan);
                $('#harga').val(data.harga);
            });
            $('#modal-edit').modal('show');
        }
    </script>

@endsection
