<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta name="author" content="Ricky Sambora" />

	<link rel="icon" href="{{ asset('logo.png') }}">

	<title>SI-KAYA Sistem Informasi Perikanan Budidaya Lamongan</title>

	<link rel="stylesheet" href="{{ asset('Depan/assets/css/bootstrap.css') }}">
	<link rel="stylesheet" href="{{ asset('Depan/assets/css/font-icons/entypo/css/entypo.css') }}">
	<link rel="stylesheet" href="{{ asset('Depan/assets/css/neon.css') }}">
	@yield('css')
	<script src="{{ asset('Depan/assets/js/jquery-1.11.3.min.js') }}"></script>


</head>
<body>

<div class="wrap">
	
	<!-- Logo and Navigation -->
<div class="site-header-container container">

	<div class="row">
	
		<div class="col-md-12">
			
			<header class="site-header">
			
				<section class="site-logo">
					<div style="float: left">
						<a href="{{ url('/') }}">
							<img src="{{ asset('logo.png') }}" width="60" height="60" />
						</a>
					</div>
					<div style="margin-top: 15px">
						<center><h4><a href="{{ url('/') }}" style="color: #05c3f7;">Dinas Perikanan <br> Kabupaten Lamongan</a></h4></center>
					</div>
					
				</section>
				
				<nav class="site-nav">
					
					<ul class="main-menu hidden-xs" id="main-menu">
						<li class="{{ Request::is('/') ? 'active' : '' }}">
							<a href="{{ url('/') }}">
								<span>Beranda</span>
							</a>
						</li>
						<li class="{{ Request::is('peta*') ? 'active' : '' }}">
							<a href="#">
								<span>Peta</span>
							</a>
							
							<ul>
								<li>
									<a href="{{ url('peta/kecamatan') }}">
										<span>Potensi Budidaya Per Kecamatan</span>
									</a>
								</li>
								<li>
									<a href="{{ url('peta/desa') }}">
										<span>Potensi Budidaya Per Desa</span>
									</a>
								</li>
							</ul>
						</li>
						<li class="{{ Request::is('tabulasi*') ? 'active' : '' }}">
							<a href="#">
								<span>Tabulasi</span>
							</a>
							
							<ul>
								<li>
									@php
										$thn = Date('Y');
									@endphp
									<a href="{{ url('tabulasi/tahun/'.$thn.'/'.$thn) }}">
										<span>Produksi Per Tahun</span>
									</a>
								</li>
								<li>
									<a href="{{ url('tabulasi/rtp/'.$thn.'/'.$thn.'/0') }}">
										<span>Jumlah RTP</span>
									</a>
								</li>
							</ul>
						</li>
						<li class="{{ Request::is('grafik*') ? 'active' : '' }}">
							<a href="#">
								<span>Grafik</span>
							</a>
							
							<ul>
								<li>
									<a href="{{ url('grafik/tahun') }}">
										<span>Produksi Per Tahun</span>
									</a>
								</li>
								<li>
									<a href="{{ url('grafik/luasan') }}">
										<span>Jumlah Luasan</span>
									</a>
								</li>
							</ul>
						</li>
						<li class="{{ Request::is('berita_utama*') ? 'active' : '' }}">
							<a href="{{ url('berita_utama') }}">
								<span>Berita</span>
							</a>
						</li>
						<li class="{{ Request::is('meta_data*') ? 'active' : '' }}">
							<a href="{{ url('meta_data') }}">
								<span>Meta Data</span>
							</a>
						</li>
					</ul>
					
				
					<div class="visible-xs">
						
						<a href="#" class="menu-trigger">
							<i class="entypo-menu"></i>
						</a>
						
					</div>
				</nav>
				
			</header>
			
		</div>
		
	</div>
	
</div>	

@yield('konten')

<!-- Portfolio -->
<section class="portfolio-widget">
	
	<div class="container">
		
		<div class="row">
			
			<div class="col-sm-3">
				
				<div class="portfolio-info">
					<h3>
						<a href="{{ url('/berita_utama') }}">Berita</a>
					</h3>
				</div>
				
			</div>
			@foreach ($berita as $brt)
			<div class="col-sm-3">
				<div class="portfolio-item">
					<a href="{{ url('baca_berita_utama/'.$brt->id) }}" class="image">
						<img src="{{ asset('img/berita/'.$brt->foto) }}" class="img-rounded" height="200" width="200"/>
						<span class="hover-zoom"></span>
					</a>
					<h4>
						<a href="{{ url('baca_berita_utama/'.$brt->id) }}" class="name">{{ $brt->judul }}</a>
					</h4>
				</div>
			</div>
			@endforeach

		</div>
		
	</div>
	
</section>


	<!-- Footer Widgets -->
<section class="footer-widgets">
	
	<div class="container">
		
		<div class="row">
			
			<div class="col-sm-6">
				
				<a href="{{ url('/') }}">
					<h1>SI-KAYA Sistem Perikanan Budidaya Kabupaten Lamongan</h1>
				</a>
				
				<p>
					Merupakan Sistem Informasi Geografis perikanan budidaya yang dibuat oleh Dinas Perikanan Pemerintah Kabupaten Lamongan.
				</p>
				<p>
					Menjamin transparansi  informasi Publik berdasarkan UU No. 14 Tahun 2008 tentang Keterbukaan Informasi Publik.
				</p>
				
			</div>
			
			<div class="col-sm-3">
				
				<h5>Alamat</h5>
				
				<p>
					-
				</p>
				
			</div>
			
			<div class="col-sm-3">
				
				<h5>Kontak</h5>
				
				<p>
					-
				</p>
				
			</div>
			
		</div>
		
	</div>
	
</section>

<!-- Site Footer -->
<footer class="site-footer">

	<div class="container">
	
		<div class="row">
			
			<div class="col-sm-6">
				SI-KAYA Lamongan - Kabupaten Lamongan 2016-{{ Date('Y') }}.
			</div>
			
			<div class="col-sm-6">
				
				
			</div>
			
		</div>
		
	</div>
	
</footer>	
</div>


	<!-- Bottom scripts (common) -->
	<script src="{{ asset('Depan/assets/js/gsap/TweenMax.min.js') }}"></script>
	<script src="{{ asset('Depan/assets/js/bootstrap.js') }}"></script>
	<script src="{{ asset('Depan/assets/js/joinable.js') }}"></script>
	<script src="{{ asset('Depan/assets/js/resizeable.js') }}"></script>
	<script src="{{ asset('Depan/assets/js/neon-slider.js') }}"></script>


	<!-- JavaScripts initializations and stuff -->
	<script src="{{ asset('Depan/assets/js/neon-custom.js') }}"></script>

	@yield('js')

</body>
</html>