<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta name="description" content="Perikanan Lamongan" />
	<meta name="author" content="Sambora07" />

	<link rel="icon" href="{{ asset('assets/images/favicon.ico') }}">

	<title>Perikanan Lamongan</title>

	<link rel="stylesheet" href="{{ asset('assets/js/jquery-ui/css/no-theme/jquery-ui-1.10.3.custom.min.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/css/font-icons/entypo/css/entypo.css') }}">
	<link rel="stylesheet" href="//fonts.googleapis.com/css?family=Noto+Sans:400,700,400italic">
	<link rel="stylesheet" href="{{ asset('assets/css/bootstrap.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/css/neon-core.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/css/neon-theme.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/css/neon-forms.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/css/skins/facebook.css') }}">

	<script src="{{ asset('assets/js/jquery-1.11.3.min.js') }}"></script>

    @yield('css')

</head>
<body class="page-body skin-facebook">

<div class="page-container"><!-- add class "sidebar-collapsed" to close sidebar by default, "chat-visible" to make chat appear always -->
	
	<div class="sidebar-menu">

		<div class="sidebar-menu-inner">
			
			<header class="logo-env">

				<!-- logo -->
				<!--<div class="logo">-->
				<!--	<a href="{{ url('/home') }}">-->
				<!--		<img src="{{ asset('logo.png') }}" width="120" height="100" alt="" />-->
				<!--	</a>-->
				<!--</div>-->

				<!-- logo collapse icon -->
				<div class="sidebar-collapse">
					<a href="#" class="sidebar-collapse-icon"><!-- add class "with-animation" if you want sidebar to have animation during expanding/collapsing transition -->
						<i class="entypo-menu"></i>
					</a>
				</div>

								
				<!-- open/close menu icon (do not remove if you want to enable menu on mobile devices) -->
				<div class="sidebar-mobile-menu visible-xs">
					<a href="#" class="with-animation"><!-- add class "with-animation" to support animation -->
						<i class="entypo-menu"></i>
					</a>
				</div>

			</header>
			
			<div class="sidebar-user-info">

				<div class="sui-normal">
					<a href="#" class="user-link">
						<img src="{{ asset('logo(2).png') }}" width="55" alt="" class="img-circle" />

						<span>Welcome,</span>
						<strong>{{ Auth::user()->name }}</strong>
					</a>
				</div>

				<div class="sui-hover inline-links animate-in"><!-- You can remove "inline-links" class to make links appear vertically, class "animate-in" will make A elements animateable when click on user profile -->


					<a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
						<i class="entypo-lock"></i>
						Log Out
					</a>

                    <span class="close-sui-popup">&times;</span><!-- this is mandatory -->				
                </div>
			</div>
			
			@php
				$tahun = Auth::user()->tahun_data;
			@endphp
									
			<ul id="main-menu" class="main-menu">
				<!-- add class "multiple-expanded" to allow multiple submenus to open -->
				<!-- class "auto-inherit-active-class" will automatically add "active" class for parent elements who are marked already with class "active" -->
                <li class="{{ Request::is('home*') ? 'active' : '' }}">
					<a href="{{ url('/home') }}">
						<i class="entypo-gauge"></i>
						<span class="title">Dashboard</span>
					</a>
				</li>
				<li class="{{ Request::is('data*') ? 'active' : '' }}">
					<a href="{{ url('data') }}">
						<i class="entypo-monitor"></i>
						<span class="title">Data</span>
					</a>
				</li>
				<li class="{{ Request::is('harga*') ? 'active' : '' }}">
					<a href="{{ url('harga/1/'.$tahun) }}">
						<i class="entypo-credit-card"></i>
						<span class="title">Harga</span>
					</a>
				</li>
				<li class="has-sub {{ Request::is('rekap*') ? 'opened' : '' }}">
					<a href="#">
						<i class="entypo-book-open"></i>
						<span class="title">Rekapitulasi</span>
					</a>
					<ul>
						<li>
						    @if(Auth::user()->id_jabatan == 1)
    							<a href="{{ url('rekap/desa/0/0/'.$tahun.'/0') }}">
    								<i class="entypo-flow-line"></i>
    								<span class="title">
    									Rekap Produksi Ikan Per Desa
    								</span>
    							</a>
							@else
							    <a href="{{ url('rekap/desa/'.Auth::user()->id_kecamatan.'/0/'.$tahun.'/0') }}">
    								<i class="entypo-flow-line"></i>
    								<span class="title">
    									Rekap Produksi Ikan Per Desa
    								</span>
    							</a>
							@endif
						</li>
						<li>
							<a href="{{ url('rekap/kecamatan/0/'.$tahun.'/0') }}">
								<i class="entypo-flow-line"></i>
								<span class="title">Rekap Produksi Ikan Per Kecamatan</span>
							</a>
						</li>
						<li>
							<a href="{{ url('rekap/tahun') }}">
								<i class="entypo-flow-line"></i>
								<span class="title">Rekap Produksi Ikan Per Tahun</span>
							</a>
						</li>
						<li>
						    @php
								$thn = Date('Y');
							@endphp
							
							<a href="{{ url('rekap/rtp/'.$tahun.'/'.$tahun.'/0') }}">
								<i class="entypo-flow-line"></i>
								<span class="title">Rekap RTP</span>
							</a>
						</li>
						<li>
							<a href="{{ url('rekap/luas_lahan') }}">
								<i class="entypo-flow-line"></i>
								<span class="title">Rekap Luasan Lahan</span>
							</a>
						</li>
					</ul>
				</li>
				@if(Auth::user()->id_jabatan == 1)
				<li class="{{ Request::is('berita*') ? 'active' : '' }}">
					<a href="{{ url('/berita') }}">
						<i class="entypo-newspaper"></i>
						<span class="title">Berita</span>
					</a>
				</li>
				<li class="has-sub {{ Request::is('pengaturan*') ? 'opened' : '' }}">
					<a href="#">
						<i class="entypo-cog"></i>
						<span class="title">Pengaturan</span>
					</a>
					<ul>
						<li>
							<a href="{{ url('pengaturan/kecamatan') }}">
								<i class="entypo-flow-line"></i>
								<span class="title">Kecamatan</span>
							</a>
						</li>
						<li>
							<a href="{{ url('pengaturan/desa') }}">
								<i class="entypo-flow-line"></i>
								<span class="title">Desa</span>
							</a>
						</li>
						<li>
							<a href="{{ url('pengaturan/jenis_ikan') }}">
								<i class="entypo-flow-line"></i>
								<span class="title">Jenis Ikan</span>
							</a>
						</li>
					</ul>
				</li>
				@endif
			</ul>
			
		</div>

	</div>

	<div class="main-content">
				
		<div class="row">
		
			<!-- Profile Info and Notifications -->
			<div class="col-md-6 col-sm-8 clearfix">
                <ul class="user-info pull-left pull-none-xsm">
		
					<!-- Profile Info -->
					<li class="profile-info dropdown"><!-- add class "pull-right" if you want to place this from right -->
		
						<a href="{{ url('/home') }}" class="dropdown-toggle" data-toggle="dropdown">
							<img src="{{ asset('logo(2).png') }}" alt="" class="img-circle" width="44" />
							{{ Auth::user()->name }}
						</a>
		
						<ul class="dropdown-menu">
		
							<!-- Reverse Caret -->
							<li class="caret"></li>
		
							<!-- Profile sub-links -->
							<li>
								<a href="extra-timeline.html">
									<i class="entypo-user"></i>
									Edit Profile
								</a>
							</li>
						</ul>
					</li>
		
				</ul>
			</div>
		
		
			<!-- Raw Links -->
			<div class="col-md-6 col-sm-4 clearfix hidden-xs">
		
				<ul class="list-inline links-list pull-right">
					<li>
						<a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
							Log Out <i class="entypo-logout right"></i>
						</a>
						<form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
							@csrf
						</form>
					</li>
				</ul>
		
			</div>
		
		</div>
		
        <hr />
    
        @yield('konten')

		<!-- Footer -->
		<footer class="main">
			
			&copy; 2020 <strong>Perikanan Lamongan</strong>
		
		</footer>
	</div>
	
</div>


	<!-- Bottom scripts (common) -->
	<script src="{{ asset('assets/js/gsap/TweenMax.min.js') }}"></script>
	<script src="{{ asset('assets/js/jquery-ui/js/jquery-ui-1.10.3.minimal.min.js') }}"></script>
	<script src="{{ asset('assets/js/bootstrap.js') }}"></script>
	<script src="{{ asset('assets/js/joinable.js') }}"></script>
	<script src="{{ asset('assets/js/resizeable.js') }}"></script>
	<script src="{{ asset('assets/js/neon-api.js') }}"></script>
	<script src="{{ asset('assets/js/toastr.js') }}"></script>

	<!-- JavaScripts initializations and stuff -->
	<script src="{{ asset('assets/js/neon-custom.js') }}"></script>

	<!-- Imported scripts on this page -->
	<script src="{{ asset('assets/js/neon-chat.js') }}"></script>


	<!-- Demo Settings -->
	<script src="{{ asset('assets/js/neon-demo.js') }}"></script>

    @yield('js')

</body>
</html>