@extends('layouts.layout_depan')
@section('css')
<link rel="stylesheet" href="{{ asset('assets/js/datatables/datatables.css') }}">
<link rel="stylesheet" href="{{ asset('assets/js/select2/select2-bootstrap.css') }}">
<link rel="stylesheet" href="{{ asset('assets/js/select2/select2.css') }}">
@endsection
@section('konten')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <hr class="no-top-margin" />
        </div>
    </div>	
</div>
<div class="row">
    <div class="col-lg-12">
        <h2><center>Tabulasi Produksi Per Tahun</center></h2>
    </div>
</div>
<section class="portfolio-widget">
	
	<div class="container">
		<div class="row">
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Awal</label>
                    <div>
                        <select class="form-control" name="t_awal" id="t_awal">
                            @for ($i = 2014; $i <= Date('Y'); $i++)
                                <option value="{{ $i }}" @if($i == $thn_awal) selected @endif>{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Akhir</label>
                    <div>
                        <select class="form-control" name="t_akhir" id="t_akhir">
                            @for ($i = 2014; $i <= Date('Y'); $i++)
                                <option value="{{ $i }}" @if($i == $thn_akhir) selected @endif>{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tampilkan</label>
                    <div>
                        <button onclick="getUrl();" class="btn btn-primary"><i class="entypo-search"></i></button>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
		
            <div class="col-sm-12">
                <table class="table table-bordered datatable" id="table-1">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Jenis Ikan</th>
                            @for ($i = $thn_awal; $i <= $thn_akhir; $i++)
                                <th>{{ $i }} (Kg)</th>
                            @endfor
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $no=1;
                        @endphp
                        @foreach ($data_rekap as $rkp)
                            <tr>
                                <td>{{ $no }}</td>
                                <td>{{ $rkp['nama_ikan'] }}</td>
                                @foreach ($rkp['rtp'] as $qty)
                                <td style="text-align:right;">{{ number_format($qty,0,",",".") }}</td>
                                @endforeach
                            </tr>
                        @php
                            $no++;
                        @endphp
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>


@endsection

@section('js')
<script src="{{ asset('assets/js/datatables/datatables.js') }}"></script>
<script src="{{ asset('assets/js/select2/select2.min.js') }}"></script>
<script type="text/javascript">
    jQuery( document ).ready( function( $ ) {
        var $table1 = jQuery( '#table-1' );
        
        // Initialize DataTable
        $table1.DataTable( {
            "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
            "bStateSave": true
        });
        
        // Initalize Select Dropdown after DataTables is created
        $table1.closest( '.dataTables_wrapper' ).find( 'select' ).select2( {
            minimumResultsForSearch: -1
        });
    } );
</script>

<script>
    function getUrl(){
        var awl, akhr, url;
        awl = $('#t_awal').val();
        akhr = $('#t_akhir').val();
        if(akhr < awl){
            alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
        }else{
            url = "{{ url('tabulasi/tahun/') }}/"+awl+"/"+akhr;
            window.location.href = url;
        }
    }
</script>
@endsection