@extends('layouts.layout_depan')
@section('css')
<link rel="stylesheet" href="{{ asset('assets/js/datatables/datatables.css') }}">
<link rel="stylesheet" href="{{ asset('assets/js/select2/select2-bootstrap.css') }}">
<link rel="stylesheet" href="{{ asset('assets/js/select2/select2.css') }}">
@endsection

@section('konten')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <hr class="no-top-margin" />
        </div>
    </div>	
</div>
<div class="row">
    <div class="col-lg-12">
        <h2><center>Tabulasi Jumlah RTP Pertahun per Jenis Lahan</center></h2>
    </div>
</div>
<section class="portfolio-widget">
	
	<div class="container">
		<div class="row">
            <div class="col-lg-3">
                <div class="form-group">
                    <label class="control-label">Tahun Awal</label>
                    <div>
                        <select class="form-control" name="t_awal" id="t_awal">
                            @for ($i = 2014; $i <= Date('Y'); $i++)
                                <option value="{{ $i }}" @if($i == $thn_awal) selected @endif>{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="form-group">
                    <label class="control-label">Tahun Akhir</label>
                    <div>
                        <select class="form-control" name="t_akhir" id="t_akhir">
                            @for ($i = 2014; $i <= Date('Y'); $i++)
                                <option value="{{ $i }}" @if($i == $thn_akhir) selected @endif>{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="form-group">
                    <label class="control-label">Jenis Lahan</label>
                    <div>
                        <select class="form-control" name="j_lahan" id="j_lahan">
                            <option value="0" @if($lhn == 0) selected @endif>Semua Jenis Lahan</option>
                            @foreach($lahan as $value)
                                <option value="{{ $value->id_lahan }}" @if($lhn == $value->id_lahan) selected @endif>{{ $value->nama_lahan }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="form-group">
                    <label class="control-label">Tampilkan</label>
                    <div>
                        <button onclick="getUrl();" class="btn btn-primary"><i class="entypo-search"></i></button>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
		
            <div class="col-sm-12">
                <table class="table table-bordered datatable" id="table-1">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Desa</th>
                            @for ($i = $thn_awal; $i <= $thn_akhir; $i++)
                                <th>{{ $i }}</th>
                            @endfor
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $no=1;
                        @endphp
                        @foreach ($data_rekap as $value)
                            <tr>
                                <td>{{ $no }}</td>
                                <td>{{ $value['nama_desa'] }}</td>
                                @foreach ($value['rtp'] as $qty)
                                <td>{{ $qty }}</td>
                                @endforeach
                            </tr>
                            @php
                                $no++;
                            @endphp
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
@endsection

@section('js')
<script src="{{ asset('assets/js/datatables/datatables.js') }}"></script>
<script src="{{ asset('assets/js/select2/select2.min.js') }}"></script>
<script type="text/javascript">
    jQuery( document ).ready( function( $ ) {
        var $table1 = jQuery( '#table-1' );
        
        // Initialize DataTable
        $table1.DataTable( {
            "iDisplayLength": 10,
            "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]]
        });
        
        // Initalize Select Dropdown after DataTables is created
        $table1.closest( '.dataTables_wrapper' ).find( 'select' ).select2( {
            minimumResultsForSearch: -1
        });
    } );
</script>

<script>
    function getUrl(){
        var awl, akhr, lhn, url;
        awl = $('#t_awal').val();
        akhr = $('#t_akhir').val();
        lhn = $('#j_lahan').val();
        if(akhr < awl){
            alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
        }else{
            url = "{{ url('tabulasi/rtp/') }}/"+awl+"/"+akhr+"/"+lhn;
            window.location.href = url;
        }
    }
</script>
@endsection