@extends('layouts.layout_depan')
@section('css')
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.4.0/dist/leaflet.css"
    integrity="sha512-puBpdR0798OZvTTbP4A8Ix/l+A4dHDD0DGqYW6RQ+9jxkRFclaxxQb/SJAWZfWAkuyeQUytO7+7N4QKrDh+drA=="
    crossorigin=""/>
@endsection

@section('konten')
<section class="portfolio-item-details">
    <div class="col-lg-12">
        <h2><center>Peta Potensi Budidaya Per Kecamatan</center></h2>
    </div>
    <div id="mapL" style="height: 100vh; width: 100%;"></div>
</section>
@endsection

@section('js')
    <script src="https://unpkg.com/leaflet@1.4.0/dist/leaflet.js"
    integrity="sha512-QVftwZFqvtRNi0ZyCtsznlKSWOStnDORoefr1enyq5mVL4tmKB3S/EnC3rRJcxCPavG10IcrVGSmPh6Qw5lwrg=="
    crossorigin=""></script>
    <script>
        var bataskecamatan;
        var datakec;
        $( document ).ready(function() {
            var url = "{{ url('/peta/getKecamatanAll') }}";
            $.ajax({
                url: url,
                type: 'post',
                data: {
                    "_token": "{{ csrf_token() }}"
                },
                dataType: 'json',
                success: function (data) {
                    datakec=data;
                }
            });
        });
        
        function style(feature) {
            return {
                fillColor: 'blue', 
                fillOpacity: 0.5,  
                weight: 2,
                opacity: 1,
                color: '#ffffff',
                dashArray: '3'
            };
        }
        var highlight = {
            'fillColor': 'green',
            'weight': 2,
            'opacity': 1
        };
        var popupOptions ={
            'maxWidth': '400',
            'className' : 'infowindow'
        };

        var mapL = L.map('mapL', {
            center: [-7.118694, 112.411955],
            zoom: 10
        });

        var imageUrl = 'http://perikanan.peganden.id/tiled/map/{z}/{x}/{y}.png';
        var citra = L.tileLayer(imageUrl, {maxZoom: 22}).addTo(mapL);
        var googleSat = L.tileLayer('http://{s}.google.com/vt/lyrs=s&x={x}&y={y}&z={z}',{
            maxZoom: 20,
            subdomains:['mt0','mt1','mt2','mt3']
        });
        
        let batas = L.layerGroup().addTo( mapL );


        $.ajax({
            beforeSend: function (xhr) {
                if (xhr && xhr.overrideMimeType) {
                xhr.overrideMimeType('application/json;charset=utf-8');
                }
            },
            dataType: "json",
            url: "{{ url('tiled/kecamatan.geojson') }}",
            success: function(data) {
                bataskecamatan = L.geoJSON(data, {
                    onEachFeature: addMyBatas,
                    style: style
                }).bindPopup(function (layer) {
                        var id = parseInt(layer.feature.properties.Name);
                        return  "<table class='infowindow'>" +
                                "<tr style='border-bottom: 1px solid black;'><td class='judul' colspan='4' style='text-align:center;'><h5><br>KECAMATAN " + datakec[id]['NAMA_KECAMATAN'] + "</b></h5></td></tr>" +
                                "<tr><td>Lahan</td><td>Kolam</td><td><b>:</b></td><td style='text-align:right;'><b>" + datakec[id]['LAHAN'][1] + " m&sup2;</b></td></tr>" +
                                "<tr><td></td><td>Tambak</td><td><b>:</b></td><td style='text-align:right;'><b>" + datakec[id]['LAHAN'][2] + " m&sup2;</b></td></tr>" +
                                "<tr><td></td><td>Sawah Tambak</td><td><b>:</b></td><td style='text-align:right;'><b>" + datakec[id]['LAHAN'][3] + " m&sup2;</b></td></tr>" +
                                "<tr style='border-bottom: 1px solid black;'><td></td><td>Kerambah Jaring Apung</td><td><b>:</b></td><td style='text-align:right;'><b>" + datakec[id]['LAHAN'][4] + " m&sup2;</b></td></tr>" +
                                "<tr><td>RTP</td><td>Kolam</td><td><b>:</b></td><td style='text-align:right;'><b>" + datakec[id]['RTP'][1] + "</b></td></tr>" +
                                "<tr><td></td><td>Tambak</td><td><b>:</b></td><td style='text-align:right;'><b>" + datakec[id]['RTP'][2] + "</b></td></tr>" +
                                "<tr><td></td><td>Sawah Tambak</td><td><b>:</b></td><td style='text-align:right;'><b>" + datakec[id]['RTP'][3] + "</b></td></tr>" +
                                "<tr style='border-bottom: 1px solid black;'><td></td><td>Kerambah Jaring Apung</td><td><b>:</b></td><td style='text-align:right;'><b>" + datakec[id]['RTP'][4] + "</b></td></tr>" +
                                "<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>" +
                                "</table>";
                }, popupOptions);
                bataskecamatan.addTo(mapL);
            }
        });

        function addMyBatas( feature, layer ){
            layer.on("click", function (e) { 
                bataskecamatan.setStyle(style);
                layer.setStyle(highlight);
            }); 
            batas.addLayer( layer );
        }
    
        var basemapControl = {
            "Map": citra,
            "Satelit": googleSat
        }
        var layerControl = {
            
        }
        L.control.layers(basemapControl,layerControl).addTo(mapL);

    </script>
@endsection