@extends('layouts.layout_depan')
@section('konten')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <hr class="no-top-margin" />
        </div>
    </div>	
</div>
<div class="col-lg-12">
    <h2><center>Grafik Rekapitulasi Produksi Ikan Pertahun</center></h2>
</div>
<br><br>
<section class="portfolio-widget">
	
	<div class="container">
		<div class="row">
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Awal</label>
                    <div>
                        <select class="form-control" name="t_awal" id="tahunawal">
                            @for ($i = 2014; $i <= Date('Y'); $i++)
                            <option value="{{ $i }}">{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tahun Akhir</label>
                    <div>
                        <select class="form-control" name="t_akhir" id="tahunakhir">
                            @for ($i = 2014; $i <= Date('Y'); $i++)
                            <option value="{{ $i }}">{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label">Tampilkan</label>
                    <div>
                        <button id="btn-filterikan" class="btn btn-primary"><i class="entypo-search"></i></button>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
		
            <div class="col-sm-12">
                <canvas id="chart-rekap"></canvas>
            </div>
        </div>
    </div>
</section>
@endsection
@section('js')
<script src="{{ asset('chartjs/dist/Chart.js') }}"></script>

<script>
    var barChart;
    $(document).ready(function () {
        var d = new Date();
        $('#tahunawal').val(d.getUTCFullYear());
        $('#tahunakhir').val(d.getUTCFullYear());
        var tahunawal = $('#tahunawal').val();
        var tahunakhir = $('#tahunakhir').val();
        var ctx = document.getElementById("chart-rekap").getContext("2d");
        //var barChart;
        var url = "{{ url('rekapitulasi/getRekapIkanTahun/') }}"+"/"+ tahunawal + "/" + tahunakhir;
        $.ajax({
            url: url,
            type: 'post',
            data: {
                "_token": "{{ csrf_token() }}"
            },
            dataType: 'json',
            success: function (data) {
                //console.log(data);
                var barChartData = {
                    labels: data['tahun'],
                    datasets: data['dataset']
                };
                barChart = new Chart(ctx, {
                    type: 'bar',
                    data: barChartData,
                    options: {
                        responsive: true,
                        legend: {
                            position: 'top'
                        },
                        title: {
                            display: true,
                            text: 'REKAP PRODUKSI IKAN PER TAHUN (Kg)'
                        }
                    }
                });
            }
        });
        $('#btn-filterikan').click(function () {
            tahunawal = $('#tahunawal').val();
            tahunakhir = $('#tahunakhir').val();
            if(tahunakhir < tahunawal){
                alert("Tahun Akhir Tidak Boleh Lebih Kecil Dari Tahun Awal..");
            }else{
                setGrafikkan(tahunawal, tahunakhir);
            }
        });
    });
    function setGrafikkan(thn_awal, thn_akhir) {
        var ctx = document.getElementById("chart-rekap").getContext("2d");
        var url = "{{ url('rekapitulasi/getRekapIkanTahun/') }}"+"/"+ thn_awal + "/" + thn_akhir;
        $.ajax({
            url: url,
            type: 'post',
            data: {
                "_token": "{{ csrf_token() }}"
            },
            dataType: 'json',
            success: function (data) {
                //console.log(data);
                barChart.destroy();
                var barChartData = {
                    labels: data['tahun'],
                    datasets: data['dataset']
                };
                barChart = new Chart(ctx, {
                    type: 'bar',
                    data: barChartData,
                    options: {
                        responsive: true,
                        legend: {
                            position: 'top',
                        },
                        title: {
                            display: true,
                            text: 'REKAP PRODUKSI IKAN PER TAHUN'
                        }
                    }
                });
            }
        });
    }
</script>
@endsection