@extends('layouts.layout')

@section('css')
	<link rel="stylesheet" href="{{ asset('assets/js/datatables/datatables.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/js/select2/select2-bootstrap.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/js/select2/select2.css') }}">
@endsection

@section('konten')
<ol class="breadcrumb bc-3" >
    <li>
        <a href="{{ url('/home') }}"><i class="entypo-home"></i>Beranda</a>
    </li>
    <li class="active">
        <strong>Data</strong>
    </li>
</ol>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default panel-shadow" data-collapsed="0"><!-- to apply shadow add class "panel-shadow" -->
            
            <!-- panel head -->
            <div class="panel-heading">
                <div class="row">
                    <form role="form" action="{{ url('data/download_form') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                        <div class="col-sm-3">
                            <select id="kecamatan" name="kecamatan" class="form-control" required>
                                <option value="">-- Pilih Kecamatan --</option>
                                @foreach ($kecamatan as $k)
                                <option value="{{ $k->id_kecamatan }}">{{ $k->nama_kecamatan }}</option>
                                @endforeach
                            </select>
                        </div>
                        </div>
                        <div class="form-group">
                        <div class="col-sm-3">
                            <select id="bulan" name="bulan" class="form-control" required>
                                <option value="">-- Pilih Bulan --</option>
                                @for ($i = 1; $i < 13; $i++)
                                    <option value="{{ $i }}">
                                        @switch($i)
                                            @case(1)
                                                Januari
                                                @break
                                            @case(2)
                                                Februari
                                                @break
                                            @case(3)
                                                Maret
                                                @break
                                            @case(4)
                                                April
                                                @break
                                            @case(5)
                                                Mei
                                                @break
                                            @case(6)
                                                Juni
                                                @break
                                            @case(7)
                                                Juli
                                                @break
                                            @case(8)
                                                Agustus
                                                @break
                                            @case(9)
                                                September
                                                @break
                                            @case(10)
                                                Oktober
                                                @break
                                            @case(11)
                                                November
                                                @break
                                            @case(12)
                                                Desember
                                                @break
                                            @default
                                        @endswitch
                                    </option>
                                @endfor
                            </select>
                        </div>
                        </div>
                        <div class="col-sm-2">
                            <button type="submit" class="btn btn-primary"> <i class="entypo-download"></i> Unduh Form</button>
                        </div>
                    </form>
                    <form role="form" action="{{ url('data/upload') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="col-sm-2">
                            <input type="file" name="file_excel" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" required>
                        </div>
                        <div class="col-sm-2">
                            <button type="submit" class="btn btn-primary"> <i class="entypo-upload"></i> Unggah Excel</button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- panel body -->
            <div class="panel-body">
                <table class="table table-bordered datatable" id="table-1">
                    <thead>
                        <tr>
                            <th data-hide="phone">No.</th>
                            <th>Desa</th>
                            <th data-hide="phone">Kecamatan</th>
                            <th data-hide="phone,tablet">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $i = 1;
                            $tahun = Auth::user()->tahun_data;
                        @endphp
                        @foreach ($desa as $ds)
                            <tr class="odd gradeX">
                                <td>{{ $i }}</td>
                                <td>{{ $ds->nama_desa}}</td>
                                <td>{{ $ds->nama_kecamatan }}</td>
                                <td class="center">
                                    <a href="{{ url('data/detail/'.$ds->id_desa.'/'.$tahun.'/1') }}" type="button" class="btn btn-green btn-icon">
                                        Detail
                                        <i class="entypo-search"></i>
                                    </a>
                                </td>
                            </tr>
                            @php
                                $i++
                            @endphp
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="{{ asset('assets/js/datatables/datatables.js') }}"></script>
<script src="{{ asset('assets/js/select2/select2.min.js') }}"></script>
    <script type="text/javascript">
        jQuery( document ).ready( function( $ ) {
            var $table1 = jQuery( '#table-1' );
            
            // Initialize DataTable
            $table1.DataTable( {
                "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                "bStateSave": true
            });
            
            // Initalize Select Dropdown after DataTables is created
            $table1.closest( '.dataTables_wrapper' ).find( 'select' ).select2( {
                minimumResultsForSearch: -1
            });
                    
        } );

        @if ($errors->any())
            @foreach ($errors->all() as $error)
                var opts = {
                    "closeButton": true,
                    "debug": false,
                    "positionClass": "toast-top-right",
                    "onclick": null,
                    "showDuration": "300",
                    "hideDuration": "1000",
                    "timeOut": "10000",
                    "extendedTimeOut": "1000",
                    "showEasing": "swing",
                    "hideEasing": "linear",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                };
                
                toastr.error("{{ $error }}", "Gagal !!!", opts);
            @endforeach
        @endif
    </script>
@endsection
