@extends('layouts.layout')
@section('css')
	<link rel="stylesheet" href="{{ asset('assets/js/datatables/datatables.css') }}">
@endsection

@section('konten')
<ol class="breadcrumb bc-3" >
    <li>
        <a href="{{ url('/home') }}"><i class="entypo-home"></i>Beranda</a>
    </li>
    <li class="active">
        <strong>Harga</strong>
    </li>
</ol>

<div class="row">
    <div class="col-md-12">
        
        <div class="panel panel-info" data-collapsed="0">
        
            <div class="panel-heading">
                <div class="panel-title">
                    <b>Harga Ikan | Tahun {{ $tahun }}</b>
                </div>
            </div>
            
            <div class="panel-body">
                <div class="col-md-12">
                    <div class="panel panel-primary" data-collapsed="0">
                        <div class="panel-heading">
                            <div class="panel-title">
                                <b>Pilih Jenis Lahan & Tahun</b>
                            </div>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label class="control-label">Jenis Lahan</label>
                                        <div>
                                            <select class="form-control" id="jns_lahan" name="jns_lahan">
                                                @foreach ($jenis_lahan as $jl)
                                                <option value="{{ $jl->id_lahan }}" @if($jl->id_lahan == $kl) selected @endif>{{ $jl->nama_lahan }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label class="control-label">Tahun</label>
                                        <div>
                                            <select class="form-control" name="tahun" id="tahun">
                                                <option value="{{ $tahun }}" selected>{{ $tahun }}</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label class="control-label">Tampilkan</label>
                                        <div>
                                            <button onclick="getUrl();" class="btn btn-primary"><i class="entypo-search"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="panel panel-success" data-collapsed="0">
                        <div class="panel-heading">
                            <div class="panel-title">
                                <b>Data Harga Dasar Ikan | Lahan {{ $nama_lahan->nama_lahan }}</b>
                            </div>
                        </div>
                        <div class="panel-body">
                            <table class="table table-bordered datatable" id="table_dasar">
                                <thead>
                                    <tr>
                                        <th>Bulan Ke-</th>
                                        @php
                                            $n=1;
                                        @endphp
                                        @foreach ($ikan as $ik)
                                        <th id="colH-{{ $n }}" val="{{ $ik->id_ikan }}">{{ $ik->nama_ikan }}</th>
                                        @php
                                            $n++;
                                        @endphp
                                        @endforeach
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                    @for ($i = 1; $i <= 12; $i++)
                                        <tr id="{{ $i }}">
                                            <td>{{ $i }}</td>
                                            @foreach ($ikan as $ikn)
                                                <td>
                                                    @if (count($harga) > 0)
                                                        @foreach ($harga as $rep)
                                                            @if ($rep->bulan == $i && $rep->id_ikan == $ikn->id_ikan)
                                                                {{ $rep->harga }}
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                </td>
                                            @endforeach
                                        </tr>
                                    @endfor
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="panel panel-success" data-collapsed="0">
                        <div class="panel-heading">
                            <div class="panel-title">
                                <b>Data Harga Total Ikan | Lahan {{ $nama_lahan->nama_lahan }}</b>
                            </div>
                        </div>
                        <div class="panel-body">
                            <div class="col-md-12" style="overflow: scroll;">
                                <table class="table table-bordered datatable">
                                    <thead>
                                        <tr>
                                            <th>Bulan Ke-</th>
                                            @php
                                                $n=1;
                                            @endphp
                                            @foreach ($ikan as $ik)
                                            <th>{{ $ik->nama_ikan }}</th>
                                            @php
                                                $n++;
                                            @endphp
                                            @endforeach
                                            <th style="font-weight:bold; background-color: #dcdedc; text-align: center;">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($ikan as $in)
                                        @php
                                            $tb[$in->id_ikan]=0;
                                        @endphp
                                        @endforeach
                                        @foreach ($data_bawah as $db)
                                            <tr>
                                                <td>{{ $db['bulan'] }}</td>
                                                @foreach ($db['ikn'] as $k => $v)
                                                        <td align="right">{{ number_format($v, 0, ",", ".") }}</td>
                                                @endforeach
                                                <td align="right" style="font-weight:bold; background-color: #dcdedc;">{{ number_format($db['ttl'], 0, ",", ".") }}</td>
                                            </tr>
                                            @foreach ($ikan as $in)
                                            @php
                                                $tb[$in->id_ikan] += $db['ikn'][$in->id_ikan];
                                            @endphp
                                            @endforeach
                                        @endforeach
                                        <tr>
                                            <td style="font-weight:bold; background-color: #dcdedc;">TOTAL</td>
                                            @php
                                                $kbh = 0;
                                            @endphp
                                            @foreach ($tb as $t => $vt)
                                            <td align="right" style="font-weight:bold; background-color: #dcdedc;">{{ number_format($vt, 0, ",", ".") }}</td>
                                            @php
                                                $kbh+=$vt;
                                            @endphp
                                            @endforeach
                                            <td align="right" style="font-weight:bold; background-color: #dcdedc;">{{ number_format($kbh, 0, ",", ".") }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                                <div class="row" align="center">
                                    <button type="button" id="btn_cetak" class="btn btn-success"> <i class="entypo-print"></i> Cetak</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script src="{{ asset('assets/js/datatables/datatables.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jeditable.js/2.0.16/jquery.jeditable.min.js"></script>
    <script type="text/javascript">
        $( document ).ready( function() {
            $('#table_dasar').DataTable({
                "iDisplayLength": -1,
                "aLengthMenu": [[-1], ["All"]],
                "scrollX": true
            });
            $('#table_dasar td').editable("{{ url('/saveHarga') }}", {
                "placeholder": "0",
                "type": "number",
                "submitdata": function (value, settings) {
                    //console.log();
                    return {
                        "_token": "{{ csrf_token() }}",
                        "id_ikan": $('#colH-' + $(this).parent().children().index($(this))).attr("val"),
                        "bulan": $(this).closest('tr').attr('id'),
                        "kd_lahan": $('#jns_lahan').val(),
                        "tahun": $('#tahun').val()
                    };
                }
            });
        } );
    </script>
    <script>
        function getUrl(){
            var kl, th, url;
            kl = $('#jns_lahan').val();
            th = $('#tahun').val();
            url = "{{ url('harga/') }}/"+kl+"/"+th;
            window.location.href = url;
        }

        $('#btn_cetak').click(function(){
            var kl, th, url;
            kl = $('#jns_lahan').val();
            th = $('#tahun').val();
            window.location = "{{ url('harga/CetakHargaTotalIkan/') }}/"+kl+'/'+th;
        });
    </script>
@endsection
