@extends('layouts.layout')
@section('css')
	<link rel="stylesheet" href="{{ asset('assets/js/datatables/datatables.css') }}">
@endsection

@section('konten')
<ol class="breadcrumb bc-3" >
    <li>
        <a href="{{ url('/home') }}"><i class="entypo-home"></i>Beranda</a>
    </li>
    <li>
        <a href="{{ url('/data') }}"><i class="entypo-monitor"></i>Data</a>
    </li>
    <li class="active">
        <strong>Detail</strong>
    </li>
</ol>


<div class="panel panel-success" data-collapsed="0">
					
    <!-- panel head -->
    <div class="panel-heading">
        <div class="panel-title">Detail Desa {{ $desa->nama_desa }} | Tahun {{ $tahun }}</div>
        
    </div>
    
    <!-- panel body -->
    <div class="panel-body">
        
        <div class="panel panel-info" data-collapsed="0">
					
            <!-- panel head -->
            <div class="panel-heading">
                <div class="panel-title">Pilih Jenis Lahan & Tahun | Unduh Dan Unggah File Excel</div>
            </div>
            <!-- panel body -->
            <div class="panel-body">
                <form role="form" class="form-horizontal form-groups-bordered">
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Jenis Lahan</label>
                        <div class="col-sm-2">
                            <select id="lahan" class="form-control">
                                @foreach ($lahan as $l)
                                    <option value="{{ $l->id_lahan }}" @if ($jns_lahan == $l->id_lahan) selected @endif>{{ $l->nama_lahan }}</option>
                                @endforeach
                            </select>
                        </div>
                        <label class="col-sm-1 control-label">Tahun</label>
                        <div class="col-sm-2">
                            <select id="tahun" class="form-control">
                                <option value="{{ $tahun }}"selected>{{ $tahun }}</option>
                            </select>
                        </div>
                        <div class="col-sm-1">
                            <button onclick="cari()" type="button" class="btn btn-info">
                                <i class="entypo-search"></i>
                            </button>
                        </div>
                        <div class="col-sm-2">
                            <a onclick="unduh_form()" type="button" class="btn btn-green btn-icon">
                                Unduh Form
                                <i class="entypo-download"></i>
                            </a>
                        </div>
                        <div class="col-sm-2">
                            <a onclick="showUpload();" type="button" class="btn btn-green btn-icon">
                                Upload Excel
                                <i class="entypo-upload"></i>
                            </a>
                        </div>
                    </div>
                </form>
                
            </div>
            
        </div>
        
    </div>
    <div class="panel-body">
        <div class="panel panel-info" data-collapsed="0">
            <!-- panel head -->
            <div class="panel-heading">
                <div class="panel-title">Luasan Lahan & RTP</div>
            </div>
            <!-- panel body -->
            <div class="panel-body">
                <form role="form" class="form-horizontal form-groups-bordered" action="{{ url('detail/update_rtp') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="tahun" value="{{ $tahun }}">
                    <input type="hidden" name="id_desa" value="{{ $desa->id_desa }}">
                    <input type="hidden" name="lahan" value="{{ $jns_lahan }}">
                    @php
                    $rtp_kol =0;
                    $luas_kol = 0;
                    if($rtp_kolam != null){
                    $rtp_kol =$rtp_kolam->qty;
                    }
                    if($luas_kolam != null){
                    $luas_kol = $luas_kolam->qty;
                    }
                    @endphp
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Luasan {{ $nama_lahan->nama_lahan }}</label>
                        <div class="col-sm-3">
                            <input type="number" class="form-control" id="luas_kolam" name="luas_kolam" value="{{ $luas_kol }}" min="0" required>
                        </div>
                        <label class="col-sm-2 control-label">RTP {{ $nama_lahan->nama_lahan }}</label>
                        <div class="col-sm-3">
                            <input type="number" class="form-control" id="rtp_kolam" name="rtp_kolam" value="{{ $rtp_kol }}" min="0" required>
                        </div>
                        <div class="col-sm-2">
                            <button type="submit" class="btn btn-green btn-icon"><i class="entypo-floppy"></i> Simpan</button>
                        </div>
                    </div>
                </form>
                
            </div>
            
        </div>
        
    </div>
    <div class="panel-body">
        <div class="panel panel-info" data-collapsed="0">
            <!-- panel head -->
            <div class="panel-heading">
                <div class="panel-title">Data Jumlah Ikan | Lahan</div>
            </div>
            <!-- panel body -->
            <div class="panel-body">
                <table class="table table-bordered datatable" id="tbl_report">
                    <thead>
                        <tr>
                            <th>Bulan ke-</th>
                            @php
                            $n = 1;
                            @endphp
                            @foreach ($ikan as $ik)
                                <th id="col-{{ $n }}" val="{{ $ik->id_ikan }}">{{ $ik->nama_ikan }}</th>
                            @php
                            $n ++;
                            @endphp
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($data as $dt)
                            <tr id="{{ $dt['bulan'] }}">
                                <td>{{ $dt['bulan'] }}</td>
                                @foreach ($ikan as $ikn)
                                @if(empty($dt['qty'][$ikn->id_ikan]))
                                <td>0</td>
                                @else
                                <td>{{ $dt['qty'][$ikn->id_ikan] }}</td>
                                @endif
                                @endforeach
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        
    </div>
    
</div>

<div class="modal fade" id="modal-1">
    <div class="modal-dialog">
        <div class="modal-content">                    
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Unggah Excel</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="{{ url('data_detail/upload') }}" class="form-horizontal" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <input type="hidden" name="id_desa" value="{{ $desa->id_desa }}">
                    <div class="form-group">
                        <label for="field-1" class="col-sm-3 control-label">File Excel</label>
                        <div class="col-sm-5">
                            <input type="file" name="file_excel" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" required>
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-red" data-dismiss="modal">Batal</button>
                <button type="submit"  class="btn btn-green">Unggah</button>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/datatables/datatables.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jeditable.js/2.0.16/jquery.jeditable.min.js"></script>
        <script>

        function cari(){
            var lh = $('#lahan').val();
            var th = $('#tahun').val();
            var ds = {{ $id_desa }}
            url = "{{ url('data/detail/') }}/"+ds+"/"+th+"/"+lh;
            window.location.href = url;
        }

        function updateVal(currentEle, value) {
            $(currentEle).html('<input class="thVal" type="text" value="' + value + '" />');
            $(".thVal").focus();
            $(".thVal").keyup(function (event) {
                if (event.keyCode == 13) {
                    $(currentEle).html($(".thVal").val().trim());
                }
            });

            $(document).click(function () { 
                $(currentEle).html($(".thVal").val().trim());
            });
        }
    </script>

    <script>
        function unduh_form(){
            var lahan = $('#lahan').val();
            var tahun = $('#tahun').val();
            var id_desa = "{{ $desa->id_desa }}";
            var url ="{{ url('export_detail') }}"
            window.location = url + '/' + id_desa + '/' + lahan + '/' + tahun;
        }
    </script>

    <script>
        function showUpload(){
            jQuery.noConflict();
            $('#modal-1').modal('show');
        }
    </script>
    
    <script type="text/javascript">
        $( document ).ready( function() {
            $('#tbl_report').DataTable({
                "iDisplayLength": -1,
                "aLengthMenu": [[-1], ["All"]],
                "scrollX": true
            });

            $('#tbl_report td').editable("{{ url('/saveReport') }}", {
                "placeholder": "0",
                "type": "number",
                "submitdata": function (value, settings) {
                    return {
                        "_token": "{{ csrf_token() }}",
                        "id_ikan": $('#col-' + $(this).parent().children().index($(this))).attr("val"),
                        "bulan": $(this).closest('tr').attr('id'),
                        "id_desa": "{{ $desa->id_desa }}",
                        "kd_lahan": $('#lahan').val(),
                        "tahun": $('#tahun').val()
                    };
                }
            });
        } );

        @if ($errors->any())
            @foreach ($errors->all() as $error)
                var opts = {
                    "closeButton": true,
                    "debug": false,
                    "positionClass": "toast-top-right",
                    "onclick": null,
                    "showDuration": "300",
                    "hideDuration": "1000",
                    "timeOut": "10000",
                    "extendedTimeOut": "1000",
                    "showEasing": "swing",
                    "hideEasing": "linear",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                };
                
                toastr.error("{{ $error }}", "Gagal !!!", opts);
            @endforeach
        @endif
    </script>

@endsection
