@extends('layouts.layout')
@section('css')
	<link rel="stylesheet" href="{{ asset('assets/js/datatables/datatables.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/js/select2/select2-bootstrap.css') }}">
	<link rel="stylesheet" href="{{ asset('assets/js/select2/select2.css') }}">
@endsection

@section('konten')
<ol class="breadcrumb bc-3" >
    <li>
        <a href="{{ url('/home') }}"><i class="entypo-home"></i>Beranda</a>
    </li>
    <li class="active">
        <strong>Berita</strong>
    </li>
</ol>
<table class="table table-bordered datatable" id="table-1">
    <thead>
        <tr>
            <th>No</th>
            <th>Judul</th>
            <th>Foto</th>
            <th>Tanggal Posting</th>
            <th style="text-align: center;">Aksi</th>
        </tr>
    </thead>
    <tbody>
        @php
            $no = 1;
        @endphp
        @foreach ($data as $dt)
        <tr>
            <td>{{ $no }}</td>
            <td>{{ $dt->judul }}</td>
            <td>
                <img src="{{ asset('img/berita/'.$dt->foto) }}" alt="..." height="50" width="50">
            </td>
            <td>{{ $dt->tanggal }}</td>
            <td style="text-align: center;">
                <div class="btn-group">
                    <a href="{{ url('berita/lihat/'.$dt->id) }}" type="button" class="btn btn-primary btn-icon">
                        Lihat
                        <i class="entypo-eye"></i>
                    </a>
                    <a type="button" class="btn btn-gold btn-icon" href="{{ url('berita/edit/'.$dt->id) }}">
                        Edit
                        <i class="entypo-pencil"></i>
                    </a>
                    <a href="{{ url('berita/hapus/'.$dt->id) }}" type="button" class="btn btn-red btn-icon" onclick="return confirm(' Yakin ingin hapus..?');">
                        Hapus
                        <i class="entypo-trash"></i>
                    </a>
                </div>
            </td>
        </tr>
        @php
            $no++
        @endphp
        @endforeach
    </tbody>
</table>

@endsection
@section('js')
    <script src="{{ asset('assets/js/datatables/datatables.js') }}"></script>
	<script src="{{ asset('assets/js/select2/select2.min.js') }}"></script>
    <script type="text/javascript">
        $( document ).ready( function( $ ) {
            var url_tulis = "{{ url('berita/tulis') }}";
            
            jQuery.noConflict();
            var $table1 = $( '#table-1' );
            
            // Initialize DataTable
            $table1.DataTable( {
                "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                "bStateSave": true,
                "dom": '<"toolbar"><"top"fl>rt<"bottom"ip><"clear">'
            });
            $("div.toolbar").html('<a href="'+url_tulis+'" type="button" class="btn btn-green btn-icon">Tulis Berita <i class="entypo-pencil"></i></a>');
            // Initalize Select Dropdown after DataTables is created
            $table1.closest( '.dataTables_wrapper' ).find( 'select' ).select2( {
                minimumResultsForSearch: -1
            });
        } );
    </script>

    <script>
        function showModal(){
            $('#modal-1').modal('show');
        }

        function edit(id){
            $.get({!! json_encode(url('/')) !!}+"/pengaturan/get_kecamatan/" + id , function(data) {
                $('#id_kec').val(data.id_kecamatan);
                $('#nama').val(data.nama_kecamatan);
            });
            $('#modal-edit').modal('show');
        }
    </script>

@endsection
