<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Facades\DB;
use App\Report;

class DetailImport implements ToCollection
{
    /**
    * @param Collection $collection
    */
    public function collection(Collection $collection)
    {
        $idikan = [];
        for ($i=4; $i < count($collection[0]); $i++) { 
            $dataidikan = explode(":", $collection[0][$i]);
            $idikan[$i] = $dataidikan[0];
        }

        for ($i=1; $i < count($collection); $i++) {
            $id_desa = $collection[$i][0];
            $id_lahan = $collection[$i][1];
            $tahun = $collection[$i][2];
            $bln = $collection[$i][3];
            
            for ($j=4; $j < count($collection[$i]); $j++) { 
                $cek = DB::table('report')
                ->where('id_desa', $id_desa)
                ->where('kd_lahan', $id_lahan)
                ->where('bulan', $bln)
                ->where('tahun', $tahun)
                ->where('id_ikan', $idikan[$j])
                ->first();
                
                if (empty($cek)) {
                    $Masukan = new Report;
                    $Masukan->id_desa = (String)$id_desa;
                    $Masukan->id_ikan = (Int)$idikan[$j];
                    $Masukan->kd_lahan = (Int)$id_lahan;
                    $Masukan->qty = $collection[$i][$j];
                    $Masukan->bulan = (Int)$bln;
                    $Masukan->tahun = (String)$tahun;
                    $Masukan->save();
                }else{
                    Report::where('id_ikan', (Int)$idikan[$j])
                    ->where('id_desa', (String)$id_desa)
                    ->where('kd_lahan', (Int)$id_lahan)
                    ->where('bulan', (Int)$bln)
                    ->where('tahun', (String)$tahun)
                    ->update([
                                'qty' => $collection[$i][$j]
                            ]);
                }
            }
        }

    }
}
