<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Facades\DB;
use App\Report;

class DataImport implements ToCollection
{
    /**
    * @param Collection $collection
    */
    public function collection(Collection $collection)
    {
        $idikan = [];
        for ($i=5; $i < count($collection[0]); $i++) { 
            $dataidikan = explode(":", $collection[0][$i]);
            $idikan[$i] = $dataidikan[0];
        }
        $data = [];
        for ($i=1; $i < count($collection); $i++) {
            if($collection[$i][0] != null){
                $nm_kec = (String)$collection[$i][0];
                $kec = DB::table('kecamatan')->where('nama_kecamatan', $nm_kec)->first();
                if($kec){
                    $id_kec = (String)$kec->id_kecamatan;
                    $nm_desa = (String)$collection[$i][1];
                    $nm_lahan = (String)$collection[$i][2];
                    $desa = DB::table('desa')->where('nama_desa', $nm_desa)->where('id_kecamatan', $id_kec)->first();
                    $lahan = DB::table('jenis_lahan')->where('nama_lahan', $nm_lahan)->first();
                    $id_desa = (String)$desa->id_desa;
                    $id_lahan = (String)$lahan->id_lahan;
                    $tahun = (String)$collection[$i][3];
                    $bulane ='';
                    if ($collection[$i][4] == "Januari") {
                        $bulane = "1";
                    } elseif ($collection[$i][4] == "Februari") {
                        $bulane = "2";
                    } elseif ($collection[$i][4] == "Maret") {
                        $bulane = "3";
                    } elseif ($collection[$i][4] == "April") {
                        $bulane = "4";
                    } elseif ($collection[$i][4] == "Mei") {
                        $bulane = "5";
                    } elseif ($collection[$i][4] == "Juni") {
                        $bulane = "6";
                    } elseif ($collection[$i][4] == "Juli") {
                        $bulane = "7";
                    } elseif ($collection[$i][4] == "Agustus") {
                        $bulane = "8";
                    } elseif ($collection[$i][4] == "September") {
                        $bulane = "9";
                    } elseif ($collection[$i][4] == "Oktober") {
                        $bulane = "10";
                    } elseif ($collection[$i][4] == "November") {
                        $bulane = "11";
                    } elseif ($collection[$i][4] == "Desember") {
                        $bulane = "12";
                    }
                    for ($j=5; $j < count($collection[$i]); $j++) {
                        array_push($data,[
                            'id_desa'   => $id_desa,
                            'id_lahan'  => $id_lahan,
                            'tahun'     => $tahun,
                            'bulan'     => $bulane,
                            'id_ikan'   => $idikan[$j],
                            'qty'       => $collection[$i][$j]
                        ]);
                    }
                }
            }
        }
        foreach ($data as $dt) {
            $cek = DB::table('report')
            ->where('id_desa', $dt['id_desa'])
            ->where('kd_lahan', $dt['id_lahan'])
            ->where('bulan', $dt['bulan'])
            ->where('tahun', $dt['tahun'])
            ->where('id_ikan', $dt['id_ikan'])
            ->first();
            
            if (empty($cek)) {
                $Masukan = new Report;
                $Masukan->id_desa = $dt['id_desa'];
                $Masukan->id_ikan = $dt['id_ikan'];
                $Masukan->kd_lahan = $dt['id_lahan'];
                $Masukan->qty = $dt['qty'];
                $Masukan->bulan = $dt['bulan'];
                $Masukan->tahun = $dt['tahun'];
                $Masukan->save();
            }else{
                Report::where('id_ikan', $dt['id_ikan'])
                ->where('kd_lahan', $dt['id_lahan'])
                ->where('id_desa', $dt['id_desa'])
                ->where('bulan', $dt['bulan'])
                ->where('tahun', $dt['tahun'])
                ->update([
                            'qty' => $dt['qty']
                        ]);
            }
        }
        
    }
}
