<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class EnsureSingleDeviceLogin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::check()) {
            $user = Auth::user();
            $currentSessionId = session()->getId();
            $cachedSessionId = Cache::get('user-session-' . $user->id);

            if ($cachedSessionId && $cachedSessionId !== $currentSessionId) {
                // Logout the current session
                Auth::logout();
                return redirect('/login')->with('error','Your account is logged in on another device.');
            }

            // Cache the current session id
            Cache::put('user-session-' . $user->id, $currentSessionId, now()->addMinutes(30));
        }

        return $next($request);
    }
}