<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use Auth;
use App\Exports\CetakRekapDesaTahun;
use App\Exports\CetakRekapKecamatanTahun;
use App\Exports\CetakRekapRTP;
use Maatwebsite\Excel\Facades\Excel;
use App\Report;

class RekapController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    
    public function desa($kecamatan,$jenis_lahan,$tahun,$bulan)
    {
        Report::where('id_ikan', 0)->delete(); // Hapus otomatis tabel report dengan id_ikan == 0

        if($tahun !== Auth::user()->tahun_data){
            return abort(404);
        }else{
            // Fungsi helper untuk mendapatkan array bulan berdasarkan triwulan
            $getTriwulanBulan = function($triwulan) {
                switch($triwulan) {
                    case 13: return [1, 2, 3]; // Triwulan 1
                    case 14: return [4, 5, 6]; // Triwulan 2
                    case 15: return [7, 8, 9]; // Triwulan 3
                    case 16: return [10, 11, 12]; // Triwulan 4
                    default: return [];
                }
            };
            
            $isTriwulan = in_array($bulan, [13, 14, 15, 16]);
            $bulanTriwulan = $isTriwulan ? $getTriwulanBulan($bulan) : [];
            
            if(Auth::user()->id_jabatan == 1){
                if ($kecamatan == 0) {
                    $desa = DB::table('desa')->get();
                } else {
                    $desa = DB::table('desa')->where('id_kecamatan', $kecamatan)->get();
                }
                $kec = DB::table('kecamatan')->get();
            }else{
                $desa = DB::table('desa')->where('id_kecamatan', Auth::user()->id_kecamatan)->get();
                $kec = DB::table('kecamatan')->where('id_kecamatan', Auth::user()->id_kecamatan)->get();
            }
            
            $lahan = DB::table('lahan')
                ->join('desa','desa.id_desa','lahan.kd_desa')
                ->where('tahun', $tahun)
                ->where('kd_lahan', $jenis_lahan)
                ->select(DB::raw('sum(lahan.qty) as total_lahan,lahan.tahun,desa.id_desa' ))
                ->groupBy('desa.id_desa')
                ->groupBy('lahan.tahun')
                ->get();
            $rtp = DB::table('rtp')
                ->join('desa','desa.id_desa','rtp.kd_desa')
                ->where('tahun', $tahun)
                ->where('kd_lahan', $jenis_lahan)
                ->select(DB::raw('sum(rtp.qty) as total_rtp,rtp.tahun ,desa.id_desa'))
                ->groupBy('desa.id_desa')
                ->groupBy('rtp.tahun')
                ->get();
                
            if ($kecamatan==0) {   
                if ($bulan==0) {
                    if ($jenis_lahan==0) {
                        $datatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('tahun', $tahun)
                        ->where(function($query){
                            $query->where('bulan', '!=', '');
                            $query->whereNotNull('bulan');
                        })
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                    } else {
                        $datatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('kd_lahan', $jenis_lahan)
                        ->where('tahun', $tahun)
                        ->where(function($query){
                            $query->where('bulan', '!=', '');
                            $query->whereNotNull('bulan');
                        })
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                    }
                } else {
                    if ($jenis_lahan==0) {
                        $queryDatatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('tahun', $tahun);
                        
                        if ($isTriwulan) {
                            $queryDatatotal->whereIn('bulan', $bulanTriwulan);
                        } else {
                            $queryDatatotal->where('bulan', $bulan);
                        }
                        
                        $datatotal = $queryDatatotal
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                    } else {
                        $queryDatatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('kd_lahan', $jenis_lahan)
                        ->where('tahun', $tahun);
                        
                        if ($isTriwulan) {
                            $queryDatatotal->whereIn('bulan', $bulanTriwulan);
                        } else {
                            $queryDatatotal->where('bulan', $bulan);
                        }
                        
                        $datatotal = $queryDatatotal
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                    }
                }
            }else{
                if ($bulan==0) {
                    if ($jenis_lahan==0) {
                        $datatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('tahun', $tahun)
                        ->where('kecamatan.id_kecamatan', $kecamatan)
                        ->where(function($query){
                            $query->where('bulan', '!=', '');
                            $query->whereNotNull('bulan');
                        })
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                    } else {
                        $datatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('kecamatan.id_kecamatan', $kecamatan)
                        ->where('kd_lahan', $jenis_lahan)
                        ->where('tahun', $tahun)
                        ->where(function($query){
                            $query->where('bulan', '!=', '');
                            $query->whereNotNull('bulan');
                        })
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                    }
                } else {
                    if ($jenis_lahan==0) {
                        $queryDatatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('kecamatan.id_kecamatan', $kecamatan)
                        ->where('tahun', $tahun);
                        
                        if ($isTriwulan) {
                            $queryDatatotal->whereIn('bulan', $bulanTriwulan);
                        } else {
                            $queryDatatotal->where('bulan', $bulan);
                        }
                        
                        $datatotal = $queryDatatotal
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                    } else {
                        $queryDatatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('kecamatan.id_kecamatan', $kecamatan)
                        ->where('kd_lahan', $jenis_lahan)
                        ->where('tahun', $tahun);
                        
                        if ($isTriwulan) {
                            $queryDatatotal->whereIn('bulan', $bulanTriwulan);
                        } else {
                            $queryDatatotal->where('bulan', $bulan);
                        }
                        
                        $datatotal = $queryDatatotal
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                    }
                }
            }
            
            if ($bulan == 0) {
                if ($jenis_lahan == 0) {
                    $produksi_ikan = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->where('tahun', $tahun)
                    ->where(function($query){
                        $query->where('bulan', '!=', '');
                        $query->whereNotNull('bulan');
                    })
                    ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan,desa.id_desa'))
                    ->groupBy('desa.id_desa')
                    ->groupBy('report.id_ikan')
                    ->get();
                } else {
                    $produksi_ikan = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->where('tahun', $tahun)
                    ->where('kd_lahan', $jenis_lahan)
                    ->where(function($query){
                        $query->where('bulan', '!=', '');
                        $query->whereNotNull('bulan');
                    })
                    ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan,desa.id_desa'))
                    ->groupBy('desa.id_desa')
                    ->groupBy('report.id_ikan')
                    ->get();
                }
            } else {
                if ($jenis_lahan == 0) {
                    $queryProduksi = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->where('tahun', $tahun);
                    
                    if ($isTriwulan) {
                        $queryProduksi->whereIn('bulan', $bulanTriwulan);
                    } else {
                        $queryProduksi->where('bulan', $bulan);
                    }
                    
                    $produksi_ikan = $queryProduksi
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan,desa.id_desa'))
                        ->groupBy('desa.id_desa')
                        ->groupBy('report.id_ikan')
                        ->get();
                } else {
                    $queryProduksi = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->where('tahun', $tahun)
                        ->where('kd_lahan', $jenis_lahan);
                    
                    if ($isTriwulan) {
                        $queryProduksi->whereIn('bulan', $bulanTriwulan);
                    } else {
                        $queryProduksi->where('bulan', $bulan);
                    }
                    
                    $produksi_ikan = $queryProduksi
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan,desa.id_desa'))
                        ->groupBy('desa.id_desa')
                        ->groupBy('report.id_ikan')
                        ->get();
                }
                
            }
            
            $ikan = DB::table('jenis_ikan')->get();
            $jl = DB::table('jenis_lahan')->get();
            $data= [];
            foreach ($desa as $d) {
                $data[$d->id_desa]['nama_desa'] = $d->nama_desa;
                $data[$d->id_desa]['rtp'] = 0;
                $data[$d->id_desa]['lahan'] = 0;
                foreach ($ikan as $ik) {
                    $data[$d->id_desa]['ikan'][$ik->id_ikan] = 0;
                }
                $data[$d->id_desa]['total'] = 0;
            }
            $data_total  = array(
                'totale' => "TOTAL",
                'totalrtp' => 0,
                'totallahan' => 0  
            );
            foreach ($ikan as $ik) {
                $data_total[$ik->id_ikan]=0;
            }
            foreach ($data_total as $key => $total) {
                foreach ($datatotal as $dtotal) {
                    $data_total[$dtotal->id_ikan] = $dtotal->total_produksi;
                }
            }
            foreach ($data as $key => $rekap) {
                foreach ($produksi_ikan as $pi) {
                    if ($key == $pi->id_desa) {
                        $data[$pi->id_desa]['ikan'][$pi->id_ikan] = $pi->total_produksi;
                    }
                }
                foreach ($lahan as $value_lahan) {
                    if ($key == $value_lahan->id_desa) {
                        $data[$value_lahan->id_desa]['lahan'] = $value_lahan->total_lahan;
                    }
                }
                foreach ($rtp as $value_rtp) {
                    if ($key == $value_rtp->id_desa) {
                        $data[$value_rtp->id_desa]['rtp'] = $value_rtp->total_rtp;
                    }
                }
                // foreach ($kecamatantotal as $value_total) {
                //     if ($key == $value_total['id_kecamatan']) {
                //         $data_rekap[$value_total['id_kecamatan']]['total'] = $value_total['qty'];
                //         $kabeh+=$value_total['qty'];
                //     }
                // }
            }
            // dd($data_total);
            return view('rekap.desa')
                ->with('kec',$kec)
                ->with('jl',$jl)
                ->with('kecamatan',$kecamatan)
                ->with('jenis_lahan',$jenis_lahan)
                ->with('tahun',$tahun)
                ->with('bulan',$bulan)
                ->with('ikan',$ikan)
                ->with('ikan2',$ikan)
                ->with('data_total', $data_total)
                ->with('data',$data);
        }
    }

    public function kecamatan($jenis_lahan,$tahun,$bulan)
    {
        Report::where('id_ikan', 0)->delete(); // Hapus otomatis tabel report dengan id_ikan == 0
        
        if($tahun !== Auth::user()->tahun_data){
            return abort(404);
        }else{
            // Fungsi helper untuk mendapatkan array bulan berdasarkan triwulan
            $getTriwulanBulan = function($triwulan) {
                switch($triwulan) {
                    case 13: return [1, 2, 3]; // Triwulan 1
                    case 14: return [4, 5, 6]; // Triwulan 2
                    case 15: return [7, 8, 9]; // Triwulan 3
                    case 16: return [10, 11, 12]; // Triwulan 4
                    default: return [];
                }
            };
            
            $isTriwulan = in_array($bulan, [13, 14, 15, 16]);
            $bulanTriwulan = $isTriwulan ? $getTriwulanBulan($bulan) : [];
            
            if ($bulan==0) {
                if ($jenis_lahan==0) {
                    $datatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->where('report.tahun', $tahun)
                        ->where(function($query){
                            $query->where('report.bulan', '!=', '');
                            $query->whereNotNull('report.bulan');
                        })
                        ->groupBy('report.id_ikan')
                        ->get();
                } else {
                    $datatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('report.tahun', $tahun)
                        ->where('report.kd_lahan', $jenis_lahan)
                        ->where(function($query){
                            $query->where('report.bulan', '!=', '');
                            $query->whereNotNull('report.bulan');
                        })
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                }
            } else {
                if ($jenis_lahan==0) {
                    $queryDatatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('report.tahun', $tahun);
                    
                    if ($isTriwulan) {
                        $queryDatatotal->whereIn('report.bulan', $bulanTriwulan);
                    } else {
                        $queryDatatotal->where('report.bulan', $bulan);
                    }
                    
                    $datatotal = $queryDatatotal
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                } else {
                    $queryDatatotal = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('report.kd_lahan', $jenis_lahan)
                        ->where('report.tahun', $tahun);
                    
                    if ($isTriwulan) {
                        $queryDatatotal->whereIn('report.bulan', $bulanTriwulan);
                    } else {
                        $queryDatatotal->where('report.bulan', $bulan);
                    }
                    
                    $datatotal = $queryDatatotal
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                        ->groupBy('report.id_ikan')
                        ->get();
                }
            }
            
            if ($bulan==0) {
                if ($jenis_lahan==0) {
                    $produksi_ikan = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('tahun', $tahun)
                        ->where(function($query){
                            $query->where('report.bulan', '!=', '');
                            $query->whereNotNull('report.bulan');
                        })
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan, report.tahun,kecamatan.id_kecamatan'))
                        ->groupBy('kecamatan.id_kecamatan')
                        ->groupBy('report.id_ikan')
                        ->groupBy('report.tahun')
                        ->get();
                } else {
                    $produksi_ikan = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('kd_lahan', $jenis_lahan)
                        ->where('tahun', $tahun)
                        ->where(function($query){
                            $query->where('report.bulan', '!=', '');
                            $query->whereNotNull('report.bulan');
                        })
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan, report.tahun,kecamatan.id_kecamatan'))
                        ->groupBy('kecamatan.id_kecamatan')
                        ->groupBy('report.id_ikan')
                        ->groupBy('report.tahun')
                        ->get();
                }
            } else {
                if ($jenis_lahan==0) {
                    $queryProduksi = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('tahun', $tahun);
                    
                    if ($isTriwulan) {
                        $queryProduksi->whereIn('bulan', $bulanTriwulan);
                    } else {
                        $queryProduksi->where('bulan', $bulan);
                    }
                    
                    $produksi_ikan = $queryProduksi
                        ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan, report.tahun,kecamatan.id_kecamatan'))
                        ->groupBy('kecamatan.id_kecamatan')
                        ->groupBy('report.id_ikan')
                        ->groupBy('report.tahun')
                        ->get();
                } else {
                    $queryProduksi = DB::table('report')
                        ->join('desa','desa.id_desa','report.id_desa')
                        ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                        ->where('kd_lahan', $jenis_lahan)
                        ->where('tahun', $tahun);
                    
                    if ($isTriwulan) {
                        $queryProduksi->whereIn('bulan', $bulanTriwulan);
                    } else {
                        $queryProduksi->where('bulan', $bulan);
                    }
                    
                    $produksi_ikan = $queryProduksi
                        ->select(DB::raw('sum(report.qty) as total_produksi,report.id_ikan, report.tahun,kecamatan.id_kecamatan'))
                        ->groupBy('kecamatan.id_kecamatan')
                        ->groupBy('report.id_ikan')
                        ->groupBy('report.tahun')
                        ->get();
                }
            }
            
            if ($jenis_lahan==0){
                $lahan = DB::table('lahan')
                    ->join('desa','desa.id_desa','lahan.kd_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('tahun', $tahun)
                    ->select(DB::raw('sum(lahan.qty) as total_lahan,lahan.tahun,kecamatan.id_kecamatan' ))
                    ->groupBy('kecamatan.id_kecamatan')
                    ->groupBy('lahan.tahun')
                    ->get();
                $rtp = DB::table('rtp')
                    ->join('desa','desa.id_desa','rtp.kd_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('tahun', $tahun)
                    ->select(DB::raw('sum(rtp.qty) as total_rtp,rtp.tahun ,kecamatan.id_kecamatan'))
                    ->groupBy('kecamatan.id_kecamatan')
                    ->groupBy('rtp.tahun')
                    ->get();
            } else{
                $lahan = DB::table('lahan')
                    ->join('desa','desa.id_desa','lahan.kd_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('kd_lahan', $jenis_lahan)
                    ->where('tahun', $tahun)
                    ->select(DB::raw('sum(lahan.qty) as total_lahan,lahan.tahun,kecamatan.id_kecamatan' ))
                    ->groupBy('kecamatan.id_kecamatan')
                    ->groupBy('lahan.tahun')
                    ->get();
                $rtp = DB::table('rtp')
                    ->join('desa','desa.id_desa','rtp.kd_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('kd_lahan', $jenis_lahan)
                    ->where('tahun', $tahun)
                    ->select(DB::raw('sum(rtp.qty) as total_rtp,rtp.tahun ,kecamatan.id_kecamatan'))
                    ->groupBy('kecamatan.id_kecamatan')
                    ->groupBy('rtp.tahun')
                    ->get();
            }
            
            $listlahan = DB::table('jenis_lahan')->get();
            if(Auth::user()->id_jabatan == 1){
                $kecamatan = DB::table('kecamatan')->get();
            }else{
                $kecamatan = DB::table('kecamatan')->where('id_kecamatan', Auth::user()->id_kecamatan)->get();
            }
            $ikan = DB::table('jenis_ikan')->get();
            $data= [];
            foreach ($kecamatan as $k) {
                $data[$k->id_kecamatan]['nama_kecamatan'] = $k->nama_kecamatan;
                $data[$k->id_kecamatan]['rtp'] = 0;
                $data[$k->id_kecamatan]['lahan'] = 0;
                foreach ($ikan as $ik) {
                    $data[$k->id_kecamatan]['ikan'][$ik->id_ikan] = 0;
                }
                $data[$k->id_kecamatan]['total'] = 0;
            }
            $data_total  = array(
                    'total' => 'TOTAL',
                    'totalrtp' => 0,
                    'totallahan' => 0  
                );
            foreach ($ikan as $ik) {
                $data_total[$ik->id_ikan]=0;
            }
            foreach ($data_total as $key => $total) {
                foreach ($datatotal as $dtotal) {
                    $data_total[$dtotal->id_ikan] = $dtotal->total_produksi;
                }
            }
            $kabeh=0;
            foreach ($data as $key => $rekap) {
                foreach ($produksi_ikan as $pi) {
                    if ($key == $pi->id_kecamatan) {
                        $data[$pi->id_kecamatan]['ikan'][$pi->id_ikan] = $pi->total_produksi;
                    }
                }
                foreach ($lahan as $value_lahan) {
                    if ($key == $value_lahan->id_kecamatan) {
                        $data[$value_lahan->id_kecamatan]['lahan'] = $value_lahan->total_lahan;
                    }
                }
                foreach ($rtp as $value_rtp) {
                    if ($key == $value_rtp->id_kecamatan) {
                        $data[$value_rtp->id_kecamatan]['rtp'] = $value_rtp->total_rtp;
                    }
                }
                // foreach ($kecamatantotal as $value_total) {
                //     if ($key == $value_total['id_kecamatan']) {
                //         $data_rekap[$value_total['id_kecamatan']]['total'] = $value_total['qty'];
                //         $kabeh+=$value_total['qty'];
                //     }
                // }
            }
            return view('rekap.kecamatan')
                ->with('lahan',$listlahan)
                ->with('kecamatan',$kecamatan)
                ->with('ikan',$ikan)
                ->with('data',$data)
                ->with('jenis_lahan',$jenis_lahan)
                ->with('tahun',$tahun)
                ->with('ikan2',$ikan)
                ->with('data_total',$data_total)
                ->with('bulan',$bulan);
        }
    }

    public function tahun()
    {
        return view('rekap.tahun');
    }

    public function rtp($awl, $akhr, $lhn)
    {
        // if(Auth::user()->id_jabatan == 1){
        //     $data = DB::table('rtp')
        //         ->join('desa','desa.id_desa','rtp.kd_desa')
        //         ->select('desa.nama_desa','rtp.qty')
        //         ->get();
        // }else{
        //     $data = DB::table('rtp')
        //     ->join('desa','desa.id_desa','rtp.kd_desa')
        //     ->join('kecamatan as k', 'desa.id_kecamatan', 'k.id_kecamatan')
        //     ->where('k.id_kecamatan', Auth::user()->id_kecamatan)
        //     ->select('desa.nama_desa','rtp.qty')
        //     ->get();
        // }
        
        // return view('rekap.rtp')->with('data',$data);
        
        $lahan = DB::table('jenis_lahan')->get();
        $data_rekap = array();
        if ($lhn==0) {
            $data = DB::table('rtp')
            ->where('tahun', '>=', $awl)
            ->where('tahun', '<=', $akhr)
            ->select('kd_desa', DB::raw('SUM(qty) as qty'), 'tahun')
            ->groupBy('kd_desa')
            ->groupBy('tahun')->get();
        } else {
            $data = DB::table('rtp')
            ->where('tahun', '>=', $awl)
            ->where('tahun', '<=', $akhr)
            ->where('kd_lahan', $lhn)
            ->select('kd_desa', DB::raw('SUM(qty) as qty'), 'tahun')
            ->groupBy('kd_desa')
            ->groupBy('tahun')->get();
        }

        $desa = DB::table('desa as d')->join('kecamatan as k', 'k.id_kecamatan', 'd.id_kecamatan')->get();
        foreach ($desa as $value) {
            $data_rekap[$value->id_desa]['nama_desa'] = $value->nama_desa;
            for ($i = $awl; $i <= $akhr; $i++) {
                $data_rekap[$value->id_desa]['rtp'][$i] = 0;
            }
        }
        foreach ($data as $value) {
            $data_rekap[$value->kd_desa]['rtp'][$value->tahun] = $value->qty;
        }
        return view('rekap.rtp')
        ->with('lahan', $lahan)
        ->with('thn_awal', $awl)
        ->with('thn_akhir', $akhr)
        ->with('data_rekap', $data_rekap)
        ->with('lhn', $lhn);
    }

    public function luas_lahan()
    {
        if(Auth::user()->id_jabatan == 1){
            $data = DB::table('lahan')
                ->join('desa','desa.id_desa','lahan.kd_desa')
                ->select('desa.nama_desa','lahan.qty')
                ->get();
        }else{
            $data = DB::table('lahan')
            ->join('desa','desa.id_desa','lahan.kd_desa')
            ->join('kecamatan as k', 'desa.id_kecamatan', 'k.id_kecamatan')
            ->where('k.id_kecamatan', Auth::user()->id_kecamatan)
            ->select('desa.nama_desa','lahan.qty')
            ->get();
        }
        return view('rekap.luas_lahan')->with('data',$data);
    }

    public function dataikan(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('jenis_ikan')
                ->get();
            $ikan = [];
            foreach ($data as $dt) {
                $ikan[] = $dt->nama_ikan;
            }
            return Response::json($ikan);
        }
    }
    
    public function cetakrekapdesatahun($kec, $thn, $lhn, $bln){
        // Fungsi helper untuk mendapatkan array bulan berdasarkan triwulan
        $getTriwulanBulan = function($triwulan) {
            switch($triwulan) {
                case 13: return [1, 2, 3]; // Triwulan 1
                case 14: return [4, 5, 6]; // Triwulan 2
                case 15: return [7, 8, 9]; // Triwulan 3
                case 16: return [10, 11, 12]; // Triwulan 4
                default: return [];
            }
        };
        
        $isTriwulan = in_array($bln, [13, 14, 15, 16]);
        $bulanTriwulan = $isTriwulan ? $getTriwulanBulan($bln) : [];
        
        $data_rekap = array();
        $ikan = DB::table('jenis_ikan')->get();
        
        if ($kec == 0) {
            $desa = DB::table('desa')->get();
        } else {
            $desa = DB::table('desa as d')->leftjoin('kecamatan as k', 'd.id_kecamatan', 'k.id_kecamatan')->where('d.id_kecamatan', $kec)->get();
        }
        
        if ($lhn==0){
            $lahan = DB::table('lahan')
                    ->where('tahun', $thn)
                    ->select(DB::raw('sum(qty) as qty,tahun,kd_desa' ))
                    ->groupBy('kd_desa')
                    ->groupBy('tahun')
                    ->get();
            $rtp = DB::table('rtp')
                    ->where('tahun', $thn)
                    ->select(DB::raw('sum(qty) as qty,tahun,kd_desa' ))
                    ->groupBy('kd_desa')
                    ->groupBy('tahun')
                    ->get();
        } else{
            $lahan = DB::table('lahan as l')->join('jenis_lahan as j', 'l.kd_lahan', 'j.id_lahan')
                    ->where('l.tahun', $thn)
                    ->where('l.kd_lahan', $lhn)
                    ->select(DB::raw('sum(l.qty) as qty, l.tahun, l.kd_desa, j.nama_lahan'))
                    ->groupBy('l.kd_desa')
                    ->groupBy('l.kd_lahan')
                    ->groupBy('l.tahun')
                    ->groupBy('j.nama_lahan')
                    ->get();
            $rtp = DB::table('rtp as r')->join('jenis_lahan as j', 'r.kd_lahan', 'j.id_lahan')
                    ->where('r.tahun', $thn)
                    ->where('r.kd_lahan', $lhn)
                    ->select(DB::raw('sum(r.qty) as qty, r.tahun, r.kd_desa, j.nama_lahan'))
                    ->groupBy('r.kd_desa')
                    ->groupBy('r.kd_lahan')
                    ->groupBy('r.tahun')
                    ->groupBy('j.nama_lahan')
                    ->get();
        }
        
        if ($bln==0) {
            if ($lhn==0) {
                $data = DB::table('report')
                        ->where('tahun', $thn)
                        ->where(function($query){
                            $query->where('bulan', '!=', '');
                            $query->whereNotNull('bulan');
                        })
                        ->select(DB::raw('sum(qty) as qty, id_ikan, tahun, id_desa'))
                        ->groupBy('id_desa')
                        ->groupBy('id_ikan')
                        ->groupBy('tahun')
                        ->get();
            } else {
                $data = DB::table('report')
                        ->where('tahun', $thn)
                        ->where('kd_lahan', $lhn)
                        ->where(function($query){
                            $query->where('bulan', '!=', '');
                            $query->whereNotNull('bulan');
                        })
                        ->select(DB::raw('sum(qty) as qty, id_ikan, tahun, id_desa'))
                        ->groupBy('id_desa')
                        ->groupBy('id_ikan')
                        ->groupBy('tahun')
                        ->get();
            }
        } else {
            if ($lhn==0) {
                $queryData = DB::table('report')
                        ->where('tahun', $thn);
                
                if ($isTriwulan) {
                    $queryData->whereIn('bulan', $bulanTriwulan);
                } else {
                    $queryData->where('bulan', $bln);
                }
                
                $data = $queryData
                        ->select(DB::raw('sum(qty) as qty, id_ikan, tahun, id_desa'))
                        ->groupBy('id_desa')
                        ->groupBy('id_ikan')
                        ->groupBy('tahun')
                        ->get();
            } else {
                $queryData = DB::table('report')
                        ->where('tahun', $thn)
                        ->where('kd_lahan', $lhn);
                
                if ($isTriwulan) {
                    $queryData->whereIn('bulan', $bulanTriwulan);
                } else {
                    $queryData->where('bulan', $bln);
                }
                
                $data = $queryData
                        ->select(DB::raw('sum(qty) as qty, id_ikan, tahun, id_desa'))
                        ->groupBy('id_desa')
                        ->groupBy('id_ikan')
                        ->groupBy('tahun')
                        ->get();
            }
        }
        foreach ($desa as $value) {
            $data_rekap[$value->id_desa]['nama_desa'] = $value->nama_desa;
            $data_rekap[$value->id_desa]['rtp'] = 0;
            $data_rekap[$value->id_desa]['lahan'] = 0;
            foreach ($ikan as $val) {
                $data_rekap[$value->id_desa]['ikan'][$val->id_ikan] = 0;
            }
            if ($kec == 0) {
                $nama_kecamatan = 'Semua';
            } else {
                $nama_kecamatan = $value->nama_kecamatan;
            }
        }
        
        foreach ($data_rekap as $key => $rekap) {
            foreach ($data as $value) {
                if ($key == $value->id_desa) {
                    $data_rekap[$value->id_desa]['ikan'][$value->id_ikan] = $value->qty;
                }
            }
            foreach ($lahan as $value_lahan) {
                if ($key == $value_lahan->kd_desa) {
                    $data_rekap[$value_lahan->kd_desa]['lahan'] = $value_lahan->qty;
                }
                if ($lhn==0) {
                    $nama_lahan = "Semua_Lahan";
                } else {
                    $nama_lahan = $value_lahan->nama_lahan;
                }
                
            }
            foreach ($rtp as $value_rtp) {
                if ($key == $value_rtp->kd_desa) {
                    $data_rekap[$value_rtp->kd_desa]['rtp'] = $value_rtp->qty;
                }
            }
            if ($bln==0) {
                $nama_bulan = "Satu_Tahun";
            } else {
                switch ($bln) {
                    case '13':
                        $nama_bulan = "Triwulan_1";
                        break;
                    case '14':
                        $nama_bulan = "Triwulan_2";
                        break;
                    case '15':
                        $nama_bulan = "Triwulan_3";
                        break;
                    case '16':
                        $nama_bulan = "Triwulan_4";
                        break;
                    case '1':
                        $nama_bulan = "Januari";
                        break;
                    case '2':
                        $nama_bulan = "Februari";
                        break;
                    case '3':
                        $nama_bulan = "Maret";
                        break;
                    case '4':
                        $nama_bulan = "April";
                        break;
                    case '5':
                        $nama_bulan = "Mei";
                        break;
                    case '6':
                        $nama_bulan = "Juni";
                        break;
                    case '7':
                        $nama_bulan = "Juli";
                        break;
                    case '8':
                        $nama_bulan = "Agustus";
                        break;
                    case '9':
                        $nama_bulan = "September";
                        break;
                    case '10':
                        $nama_bulan = "Oktober";
                        break;
                    case '11':
                        $nama_bulan = "November";
                        break;
                    case '12':
                        $nama_bulan = "Desember";
                        break;
                    default:
                        $nama_bulan = "Satu_Tahun";
                        break;
                }
            }
        }
        return Excel::download(new CetakRekapDesaTahun($ikan, $data_rekap, $nama_kecamatan), 'Rekap_'.$nama_kecamatan.'_'.$nama_lahan.'_'.$nama_bulan.'_'.$thn.'.xlsx');
        // return view('rekap.cetak_desa_tahun')
        // ->with('ikan', $ikan)
        // ->with('data_rekap', $data_rekap)
        // ->with('nama_kecamatan', $nama_kecamatan);
    }
    
    public function cetakrekapkecamatantahun($tahun, $jenis_lahan, $bulan){
        
        // Fungsi helper untuk mendapatkan array bulan berdasarkan triwulan
        $getTriwulanBulan = function($triwulan) {
            switch($triwulan) {
                case 13: return [1, 2, 3]; // Triwulan 1
                case 14: return [4, 5, 6]; // Triwulan 2
                case 15: return [7, 8, 9]; // Triwulan 3
                case 16: return [10, 11, 12]; // Triwulan 4
                default: return [];
            }
        };
        
        $isTriwulan = in_array($bulan, [13, 14, 15, 16]);
        $bulanTriwulan = $isTriwulan ? $getTriwulanBulan($bulan) : [];
        
        if ($bulan==0) {
            if ($jenis_lahan==0) {
                $datatotal = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                    ->where('report.tahun', $tahun)
                    ->where(function($query){
                        $query->where('bulan', '!=', '');
                        $query->whereNotNull('bulan');
                    })
                    ->groupBy('report.id_ikan')
                    ->get();
            } else {
                $datatotal = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('report.tahun', $tahun)
                    ->where('report.kd_lahan', $jenis_lahan)
                    ->where(function($query){
                        $query->where('bulan', '!=', '');
                        $query->whereNotNull('bulan');
                    })
                    ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                    ->groupBy('report.id_ikan')
                    ->get();
            }
        } else {
            if ($jenis_lahan==0) {
                $queryDatatotal = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('report.tahun', $tahun);
                
                if ($isTriwulan) {
                    $queryDatatotal->whereIn('report.bulan', $bulanTriwulan);
                } else {
                    $queryDatatotal->where('report.bulan', $bulan);
                }
                
                $datatotal = $queryDatatotal
                    ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                    ->groupBy('report.id_ikan')
                    ->get();
            } else {
                $queryDatatotal = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('report.kd_lahan', $jenis_lahan)
                    ->where('report.tahun', $tahun);
                
                if ($isTriwulan) {
                    $queryDatatotal->whereIn('report.bulan', $bulanTriwulan);
                } else {
                    $queryDatatotal->where('report.bulan', $bulan);
                }
                
                $datatotal = $queryDatatotal
                    ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan'))
                    ->groupBy('report.id_ikan')
                    ->get();
            }
        }
        
        if ($bulan==0) {
            if ($jenis_lahan==0) {
                $produksi_ikan = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('tahun', $tahun)
                    ->where(function($query){
                        $query->where('bulan', '!=', '');
                        $query->whereNotNull('bulan');
                    })
                    ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan, report.tahun,kecamatan.id_kecamatan'))
                    ->groupBy('kecamatan.id_kecamatan')
                    ->groupBy('report.id_ikan')
                    ->groupBy('report.tahun')
                    ->get();
            } else {
                $produksi_ikan = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('kd_lahan', $jenis_lahan)
                    ->where('tahun', $tahun)
                    ->where(function($query){
                        $query->where('bulan', '!=', '');
                        $query->whereNotNull('bulan');
                    })
                    ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan, report.tahun,kecamatan.id_kecamatan'))
                    ->groupBy('kecamatan.id_kecamatan')
                    ->groupBy('report.id_ikan')
                    ->groupBy('report.tahun')
                    ->get();
            }
        } else {
            if ($jenis_lahan==0) {
                $queryProduksi = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('tahun', $tahun);
                
                if ($isTriwulan) {
                    $queryProduksi->whereIn('bulan', $bulanTriwulan);
                } else {
                    $queryProduksi->where('bulan', $bulan);
                }
                
                $produksi_ikan = $queryProduksi
                    ->select(DB::raw('sum(report.qty) as total_produksi , report.id_ikan, report.tahun,kecamatan.id_kecamatan'))
                    ->groupBy('kecamatan.id_kecamatan')
                    ->groupBy('report.id_ikan')
                    ->groupBy('report.tahun')
                    ->get();
            } else {
                $queryProduksi = DB::table('report')
                    ->join('desa','desa.id_desa','report.id_desa')
                    ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                    ->where('kd_lahan', $jenis_lahan)
                    ->where('tahun', $tahun);
                
                if ($isTriwulan) {
                    $queryProduksi->whereIn('bulan', $bulanTriwulan);
                } else {
                    $queryProduksi->where('bulan', $bulan);
                }
                
                $produksi_ikan = $queryProduksi
                    ->select(DB::raw('sum(report.qty) as total_produksi,report.id_ikan, report.tahun,kecamatan.id_kecamatan'))
                    ->groupBy('kecamatan.id_kecamatan')
                    ->groupBy('report.id_ikan')
                    ->groupBy('report.tahun')
                    ->get();
            }
        }
        
        if ($jenis_lahan==0){
            $lahan = DB::table('lahan')
                ->join('desa','desa.id_desa','lahan.kd_desa')
                ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                ->where('tahun', $tahun)
                ->select(DB::raw('sum(lahan.qty) as total_lahan,lahan.tahun,kecamatan.id_kecamatan' ))
                ->groupBy('kecamatan.id_kecamatan')
                ->groupBy('lahan.tahun')
                ->get();
            $rtp = DB::table('rtp')
                ->join('desa','desa.id_desa','rtp.kd_desa')
                ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                ->where('tahun', $tahun)
                ->select(DB::raw('sum(rtp.qty) as total_rtp,rtp.tahun ,kecamatan.id_kecamatan'))
                ->groupBy('kecamatan.id_kecamatan')
                ->groupBy('rtp.tahun')
                ->get();
        } else{
            $lahan = DB::table('lahan')
                ->join('desa','desa.id_desa','lahan.kd_desa')
                ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                ->where('kd_lahan', $jenis_lahan)
                ->where('tahun', $tahun)
                ->select(DB::raw('sum(lahan.qty) as total_lahan,lahan.tahun,kecamatan.id_kecamatan' ))
                ->groupBy('kecamatan.id_kecamatan')
                ->groupBy('lahan.tahun')
                ->get();
            $rtp = DB::table('rtp')
                ->join('desa','desa.id_desa','rtp.kd_desa')
                ->join('kecamatan','kecamatan.id_kecamatan','desa.id_kecamatan')
                ->where('kd_lahan', $jenis_lahan)
                ->where('tahun', $tahun)
                ->select(DB::raw('sum(rtp.qty) as total_rtp,rtp.tahun ,kecamatan.id_kecamatan'))
                ->groupBy('kecamatan.id_kecamatan')
                ->groupBy('rtp.tahun')
                ->get();
        }
        
        if(Auth::user()->id_jabatan == 1){
            $kecamatan = DB::table('kecamatan')->get();
        }else{
             $kecamatan = DB::table('kecamatan')->where('id_kecamatan', Auth::user()->id_kecamatan)->get();
        }
        $ikan = DB::table('jenis_ikan')->get();
        $data= [];
        foreach ($kecamatan as $k) {
            $data[$k->id_kecamatan]['nama_kecamatan'] = $k->nama_kecamatan;
            $data[$k->id_kecamatan]['rtp'] = 0;
            $data[$k->id_kecamatan]['lahan'] = 0;
            foreach ($ikan as $ik) {
                $data[$k->id_kecamatan]['ikan'][$ik->id_ikan] = 0;
            }
            $data[$k->id_kecamatan]['total'] = 0;
        }
        $data_total  = array(
                'total' => 'TOTAL',
                'totalrtp' => 0,
                'totallahan' => 0  
            );
        foreach ($ikan as $ik) {
            $data_total[$ik->id_ikan]=0;
        }
        foreach ($data_total as $key => $total) {
            foreach ($datatotal as $dtotal) {
                $data_total[$dtotal->id_ikan] = $dtotal->total_produksi;
            }
        }
        foreach ($data as $key => $rekap) {
            foreach ($produksi_ikan as $pi) {
                if ($key == $pi->id_kecamatan) {
                    $data[$pi->id_kecamatan]['ikan'][$pi->id_ikan] = $pi->total_produksi;
                }
            }
            foreach ($lahan as $value_lahan) {
                if ($key == $value_lahan->id_kecamatan) {
                    $data[$value_lahan->id_kecamatan]['lahan'] = $value_lahan->total_lahan;
                }
            }
            foreach ($rtp as $value_rtp) {
                if ($key == $value_rtp->id_kecamatan) {
                    $data[$value_rtp->id_kecamatan]['rtp'] = $value_rtp->total_rtp;
                }
            }
        }

        if ($jenis_lahan==0) {
            $nama_lahan = "Semua_Lahan";
        } else {
            $jns = DB::table('jenis_lahan')->where('id_lahan', $jenis_lahan)->first();
            $nama_lahan = $jns->nama_lahan;
        }
        if ($bulan==0) {
            $nama_bulan = "Satu_Tahun";
        } else {
            switch ($bulan) {
                case '13':
                    $nama_bulan = "Triwulan_1";
                    break;
                case '14':
                    $nama_bulan = "Triwulan_2";
                    break;
                case '15':
                    $nama_bulan = "Triwulan_3";
                    break;
                case '16':
                    $nama_bulan = "Triwulan_4";
                    break;
                case '1':
                    $nama_bulan = "Januari";
                    break;
                case '2':
                    $nama_bulan = "Februari";
                    break;
                case '3':
                    $nama_bulan = "Maret";
                    break;
                case '4':
                    $nama_bulan = "April";
                    break;
                case '5':
                    $nama_bulan = "Mei";
                    break;
                case '6':
                    $nama_bulan = "Juni";
                    break;
                case '7':
                    $nama_bulan = "Juli";
                    break;
                case '8':
                    $nama_bulan = "Agustus";
                    break;
                case '9':
                    $nama_bulan = "September";
                    break;
                case '10':
                    $nama_bulan = "Oktober";
                    break;
                case '11':
                    $nama_bulan = "November";
                    break;
                case '12':
                    $nama_bulan = "Desember";
                    break;
                default:
                    $nama_bulan = "Satu_Tahun";
                    break;
            }
        }
        //  return view('rekap.cetak_kecamatan_tahun')
        //     ->with('ikan',$ikan)
        //     ->with('data',$data)
        //     ->with('ikan2',$ikan)
        //     ->with('data_total',$data_total);
        return Excel::download(new CetakRekapKecamatanTahun($ikan, $data, $data_total), 'Rekap_'.$nama_lahan.'_'.$nama_bulan.'_'.$tahun.'.xlsx');
    }
    
    public function cetakrekaprtp($awl, $akhr, $lhn){
        $lahan = DB::table('jenis_lahan')->get();
        $data_rekap = array();
        if ($lhn==0) {
            $data = DB::table('rtp')
            ->where('tahun', '>=', $awl)
            ->where('tahun', '<=', $akhr)
            ->select('kd_desa', DB::raw('SUM(qty) as qty'), 'tahun')
            ->groupBy('kd_desa')
            ->groupBy('tahun')->get();
        } else {
            $data = DB::table('rtp')
            ->where('tahun', '>=', $awl)
            ->where('tahun', '<=', $akhr)
            ->where('kd_lahan', $lhn)
            ->select('kd_desa', DB::raw('SUM(qty) as qty'), 'tahun')
            ->groupBy('kd_desa')
            ->groupBy('tahun')->get();
        }

        $desa = DB::table('desa as d')->join('kecamatan as k', 'k.id_kecamatan', 'd.id_kecamatan')->get();
        foreach ($desa as $value) {
            $data_rekap[$value->id_desa]['nama_desa'] = $value->nama_desa;
            for ($i = $awl; $i <= $akhr; $i++) {
                $data_rekap[$value->id_desa]['rtp'][$i] = 0;
            }
        }
        foreach ($data as $value) {
            $data_rekap[$value->kd_desa]['rtp'][$value->tahun] = $value->qty;
        }
        // return view('rekap.cetak_rtp')
        // ->with('lahan', $lahan)
        // ->with('thn_awal', $awl)
        // ->with('thn_akhir', $akhr)
        // ->with('data_rekap', $data_rekap)
        // ->with('lhn', $lhn);
        return Excel::download(new CetakRekapRTP($awl, $akhr, $data_rekap), 'REKAP RTP PERIODE '.$awl.'-'.$akhr.'.xlsx');
    }
}
