<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Kecamatan;
use App\Desa;
use App\JenisIkan;
use Response;
// use Hash;

class PengaturanController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function kecamatan()
    {
        $data = Kecamatan::all();
        return view('pengaturan.kecamatan')->with('data', $data);
    }

    public function store_kecamatan(Request $request){
        $Masukan = new Kecamatan;
        $Masukan->id_kecamatan = $request->id_kec;
        $Masukan->nama_kecamatan = $request->nama;
        $Masukan->save();
        return redirect('pengaturan/kecamatan');
    }

    public function get_kecamatan(Request $request, $id){
        if($request->ajax()){
            $data = Kecamatan::where('id_kecamatan', $id)->first();
            return Response::json($data);
        }
    }

    public function update_kecamatan(Request $request){
        Kecamatan::where('id_kecamatan', $request->id_kec)->update(['nama_kecamatan' => $request->nama]);
        return redirect('pengaturan/kecamatan');
    }

    public function hapus_kecamatan(Request $request, $id){
        Kecamatan::where('id_kecamatan', $id)->delete();
        return redirect('pengaturan/kecamatan');
    }

    public function desa()
    {
        $data = Desa::join('kecamatan as k', 'desa.id_kecamatan', 'k.id_kecamatan')->get();
        $kecamatan = Kecamatan::all();
        return view('pengaturan.desa')
        ->with('data', $data)
        ->with('kecamatan', $kecamatan);
    }

    public function store_desa(Request $request){
        $Masukan = new Desa;
        $Masukan->id_desa = $request->id_des;
        $Masukan->id_kecamatan = $request->id_kec;
        $Masukan->nama_desa = $request->nama;
        $Masukan->save();
        return redirect('pengaturan/desa');
    }

    public function get_desa(Request $request, $id){
        if($request->ajax()){
            $data = Desa::where('id_desa', $id)->first();
            return Response::json($data);
        }
    }

    public function update_desa(Request $request){
        Desa::where('id_desa', $request->id_des)->update([
            'nama_desa' => $request->nama,
            'id_kecamatan' => $request->id_kec,
        ]);
        return redirect('pengaturan/desa');
    }

    public function hapus_desa(Request $request, $id){
        Desa::where('id_desa', $id)->delete();
        return redirect('pengaturan/desa');
    }

    public function jenis_ikan()
    {
        $data = JenisIkan::all();
        return view('pengaturan.jenis_ikan')
        ->with('data', $data);
    }

    public function store_ikan(Request $request){
        $Masukan = new JenisIkan;
        $Masukan->nama_ikan = $request->nama;
        $Masukan->harga = $request->harga;
        $Masukan->save();
        return redirect('pengaturan/jenis_ikan');
    }

    public function get_ikan(Request $request, $id){
        if($request->ajax()){
            $data = JenisIkan::where('id_ikan', $id)->first();
            return Response::json($data);
        }
    }

    public function update_ikan(Request $request){
        JenisIkan::where('id_ikan', $request->id_ikan)->update([
            'nama_ikan' => $request->nama,
            'harga'     => $request->harga
        ]);
        return redirect('pengaturan/jenis_ikan');
    }

    public function hapus_ikan(Request $request, $id){
        JenisIkan::where('id_ikan', $id)->delete();
        return redirect('pengaturan/jenis_ikan');
    }
    
    // public function store_user(Request $request){
    //   $data = Kecamatan::all();
    //   foreach($data as $dt){
    //         DB::table('users')->insert([
    //             'id_jabatan'   => 3,
    //             'id_kecamatan'  => $dt->id_kecamatan,
    //             'name'       => $dt->nama_kecamatan,
    //             'email'     => strtolower($dt->nama_kecamatan."@lamongan.go.id"),
    //             'password'     => Hash::make ('12345678'),
    //             'created_at'     => date('y-m-d H:i:s'),
    //             'updated_at'     => date('y-m-d H:i:s')
    //         ]);
    //   }
    // }
}
