<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;

class DepanController extends Controller
{
    public function Vpeta_kecamatan()
    {
        $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
        return view('depan.peta_kecamatan')->with('berita', $berita);
    }

    public function Vpeta_getKecamatanAll(){
        $tahun = date('Y')-1;
        $data = DB::table('kecamatan')->get();
        $lahan = DB::table('lahan as a')
                ->leftjoin('desa as b', 'a.kd_desa', 'b.id_desa')
                ->where('a.tahun', $tahun)
                ->select('b.id_kecamatan', DB::raw('SUM(qty) as qty'), 'a.kd_lahan')
                ->groupBy('b.id_kecamatan')
                ->groupBy('a.kd_lahan')->get();
        $rtp = DB::table('rtp as a')
                ->leftjoin('desa as b', 'a.kd_desa', 'b.id_desa')
                ->where('a.tahun', $tahun)
                ->select('b.id_kecamatan', DB::raw('SUM(qty) as qty'), 'a.kd_lahan')
                ->groupBy('b.id_kecamatan')
                ->groupBy('a.kd_lahan')->get();
        $arr = array();
        foreach ($data as $value){
            $arr[$value->id_kecamatan]['NAMA_KECAMATAN'] = $value->nama_kecamatan;
            for($i=1;$i<=5;$i++){
                $arr[$value->id_kecamatan]['LAHAN'][$i] = 0;
                $arr[$value->id_kecamatan]['RTP'][$i] = 0;
            }            
        }
        foreach($lahan as $value){
            $arr[$value->id_kecamatan]['LAHAN'][$value->kd_lahan] = number_format($value->qty,0,",",".") ;
        }
        foreach($rtp as $value){
            $arr[$value->id_kecamatan]['RTP'][$value->kd_lahan] = number_format($value->qty,0,",",".") ;
        }
        echo json_encode($arr);

    }

    public function Vpeta_getDesaAll(){
        $tahun = date('Y')-1;
        $data = DB::table('desa as d')->join('kecamatan as k', 'd.id_kecamatan','k.id_kecamatan')->get();
        $lahan = DB::table('lahan')->where('tahun', $tahun)->get();
        $rtp = DB::table('rtp')->where('tahun', $tahun)->get();
        $arr = array();
        foreach ($data as $value){
            $arr[$value->id_desa]['NAMA_DESA'] = $value->nama_desa;
            $arr[$value->id_desa]['NAMA_KECAMATAN'] = $value->nama_kecamatan;
            for($i=1;$i<=5;$i++){
                $arr[$value->id_desa]['LAHAN'][$i] = 0;
                $arr[$value->id_desa]['RTP'][$i] = 0;
            }            
        }
        foreach($lahan as $value){
            $arr[$value->kd_desa]['LAHAN'][$value->kd_lahan] = number_format($value->qty,0,",",".") ;
        }
        foreach($rtp as $value){
            $arr[$value->kd_desa]['RTP'][$value->kd_lahan] = number_format($value->qty,0,",",".") ;
        }
        echo json_encode($arr);
    }

    public function Vpeta_desa()
    {
        $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
        return view('depan.peta_desa')->with('berita', $berita);
    }

    public function Vtabulasi_tahun($awl, $akhr)
    {
        $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
        $data_rekap = array();
        $data = DB::table('jenis_ikan as a')
        ->leftjoin('report as b', 'a.id_ikan', 'b.id_ikan')
        ->join('desa as d', 'd.id_desa', 'b.id_desa')
        ->join('kecamatan as k', 'k.id_kecamatan', 'd.id_kecamatan')
        ->where('b.tahun', '>=', $awl)
        ->where('b.tahun', '<=', $akhr)
        ->select('a.id_ikan', 'a.nama_ikan', DB::raw('IFNULL(SUM(b.qty),0) as qty'), 'b.tahun')
        ->groupBy('a.id_ikan')
        ->groupBy('b.tahun')
        ->groupBy('a.nama_ikan')
        ->get();
        $ikan = DB::table('jenis_ikan')->get();
        foreach ($ikan as $value) {
            $data_rekap[$value->id_ikan]['nama_ikan'] = $value->nama_ikan;
            for ($i = $awl; $i <= $akhr; $i++) {
                $data_rekap[$value->id_ikan]['rtp'][$i] = 0;
            }
        }
        foreach ($data as $value) {
            $data_rekap[$value->id_ikan]['rtp'][$value->tahun] = $value->qty;
        }
        return view('depan.tabulasi_tahun')
        ->with('berita', $berita)
        ->with('thn_awal', $awl)
        ->with('thn_akhir', $akhr)
        ->with('data_rekap', $data_rekap);
    }

    public function Vtabulasi_rtp($awl, $akhr, $lhn)
    {
        $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
        $lahan = DB::table('jenis_lahan')->get();
        $data_rekap = array();
        if ($lhn==0) {
            $data = DB::table('rtp')
            ->where('tahun', '>=', $awl)
            ->where('tahun', '<=', $akhr)
            ->select('kd_desa', DB::raw('SUM(qty) as qty'), 'tahun')
            ->groupBy('kd_desa')
            ->groupBy('tahun')->get();
        } else {
            $data = DB::table('rtp')
            ->where('tahun', '>=', $awl)
            ->where('tahun', '<=', $akhr)
            ->where('kd_lahan', $lhn)
            ->select('kd_desa', DB::raw('SUM(qty) as qty'), 'tahun')
            ->groupBy('kd_desa')
            ->groupBy('tahun')->get();
        }

        $desa = DB::table('desa as d')->join('kecamatan as k', 'k.id_kecamatan', 'd.id_kecamatan')->get();
        foreach ($desa as $value) {
            $data_rekap[$value->id_desa]['nama_desa'] = $value->nama_desa;
            for ($i = $awl; $i <= $akhr; $i++) {
                $data_rekap[$value->id_desa]['rtp'][$i] = 0;
            }
        }
        foreach ($data as $value) {
            $data_rekap[$value->kd_desa]['rtp'][$value->tahun] = $value->qty;
        }
        return view('depan.tabulasi_rtp')
        ->with('berita', $berita)
        ->with('lahan', $lahan)
        ->with('thn_awal', $awl)
        ->with('thn_akhir', $akhr)
        ->with('data_rekap', $data_rekap)
        ->with('lhn', $lhn);
    }

    public function Vgrafik_tahun()
    {
        $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
        return view('depan.grafik_tahun')->with('berita', $berita);
    }

    public function Vgrafik_luasan()
    {
        $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
        return view('depan.grafik_luasan')->with('berita', $berita);
    }

    public function getRekapIkanTahun(Request $request, $tahunawal, $tahunakhir){
        if ($request->ajax()) {
            $ikan = DB::table('jenis_ikan')->get();
            $data_ikan = array();
            $data = DB::table('jenis_ikan as a')
            ->leftjoin('report as b', 'a.id_ikan', 'b.id_ikan')
            ->join('desa as d','d.id_desa','b.id_desa')
            ->join('kecamatan as k', 'd.id_kecamatan', 'k.id_kecamatan')
            ->where('b.tahun', '>=', $tahunawal)->where('b.tahun', '<=', $tahunakhir)
            ->select('a.id_ikan','a.nama_ikan', 'b.tahun', DB::raw('IFNULL(SUM(b.qty),0) as qty'))
            ->groupBy('id_ikan')->groupBy('nama_ikan')->groupBy('tahun')->get();
            $n = 0;
            foreach ($ikan as $value) {
                for ($i = $tahunawal; $i <= $tahunakhir; $i++) {
                    $data_ikan[$value->id_ikan]['label'] = $value->nama_ikan;
                    $data_ikan[$value->id_ikan]['backgroundColor'] = getColor($n);
                    $data_ikan[$value->id_ikan]['data'][$i] = 0;
                }
                $n++;
            }

            foreach ($data as $value) {
                $data_ikan[$value->id_ikan]['data'][$value->tahun] = $value->qty;
            }

            foreach ($ikan as $value) {
                $n = 0;
                for ($i = $tahunawal; $i <= $tahunakhir; $i++) {
                    $data_ikan[$value->id_ikan]['data'][$n] = $data_ikan[$value->id_ikan]['data'][$i];
                    unset($data_ikan[$value->id_ikan]['data'][$i]);
                    $n++;
                }
            }
            $n = 0;
            foreach ($ikan as $value) {
                $data_ikan[$n] = $data_ikan[$value->id_ikan];
                unset($data_ikan[$value->id_ikan]);
                $n++;
            }
            $tahun = array();
            for ($i = $tahunawal; $i <= $tahunakhir; $i++) {
                array_push($tahun, $i);
            }
            // echo json_encode(array("tahun" => $tahun, "dataset" => $data_ikan));
            return Response::json(array("tahun" => $tahun, "dataset" => $data_ikan));
        }
    }

    public function getRekapLahanTahun(Request $request, $tahunawal, $tahunakhir){
        if ($request->ajax()) {
            $lahan['tahun'] = array();
            $lahan[1] = array();
            $lahan[2] = array();
            $lahan[3] = array();
            $lahan[4] = array();
            $lahan[5] = array();
            for ($i = $tahunawal; $i <= $tahunakhir; $i++) {
                //array_push($lahan['tahun'],$i);
                $lahan[1][$i] = 0;
                $lahan[2][$i] = 0;
                $lahan[3][$i] = 0;
                $lahan[4][$i] = 0;
                $lahan[5][$i] = 0;
            }

            $data = DB::table('lahan')->where('tahun', '>=', $tahunawal)->where('tahun', '<=', $tahunakhir)
            ->select(DB::raw('SUM(qty) as qty'), 'kd_lahan', 'tahun')
            ->groupBy('kd_lahan')
            ->groupBy('tahun')->get();

            foreach ($data as $value) {
                $lahan[$value->kd_lahan][$value->tahun] = $value->qty;
            }

            foreach ($lahan as $key => $value) {
                $n = 0;
                foreach ($value as $k => $v) {
                    $lahan['kolam'][$n] = $lahan[1][$k];
                    $lahan['tambak'][$n] = $lahan[2][$k];
                    $lahan['sawah'][$n] = $lahan[3][$k];
                    $lahan['kerambah'][$n] = $lahan[4][$k];
                    $lahan['tancap'][$n] = $lahan[5][$k];
                    $n++;
                }
            }
            for ($i = $tahunawal; $i <= $tahunakhir; $i++) {
                array_push($lahan['tahun'], $i);
                unset($lahan[1]);
                unset($lahan[2]);
                unset($lahan[3]);
                unset($lahan[4]);
                unset($lahan[5]);
            }
            // echo json_encode($lahan);
            return Response::json($lahan);
        }
    }

    public function Vberita()
    {
        $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
        $list = DB::table('berita')->paginate(6);
        return view('depan.berita')->with('berita', $berita)->with('list', $list);
    }

    public function Vbaca_berita($id)
    {
        $baca = DB::table('berita')->where('id', $id)->first();
        $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
        $terbaru = DB::table('berita')->orderBy('id', 'DESC')->limit(5)->get();
        return view('depan.baca_berita')->with('baca', $baca)->with('berita', $berita)->with('terbaru', $terbaru);
    }

    public function Vmeta()
    {
        $berita = DB::table('berita')->inRandomOrder()->limit(3)->get();
        return view('depan.meta_data')->with('berita', $berita);
    }
    
}

function getColor($n) {
    $color = array(
        "rgba(232, 48, 48, 1)",
        "rgba(232, 183, 48, 1)",
        "rgba(195, 232, 48, 1)",
        "rgba(61, 232, 48, 1)",
        "rgba(48, 232, 198, 1)",
        "rgba(48, 125, 232, 1)",
        "rgba(201, 48, 232, 1)",
        "rgba(202, 48, 6, 1)",
        "rgba(232, 48, 116, 1)",
        "rgba(151, 20, 184, 1)",
        "rgba(147, 34, 16, 1)",
        "rgba(0, 48, 48, 1)",
        "rgba(183, 0, 48, 1)",
        "rgba(4, 132, 0, 1)",
        "rgba(3, 232, 148, 1)",
        "rgba(48, 0, 198, 1)",
        "rgba(0, 48, 232, 1)",
        "rgba(201, 0, 232, 1)",
        "rgba(232, 0, 6, 1)",
        "rgba(232, 48, 0, 1)",
        "rgba(151, 20, 0, 1)",
        "rgba(147, 34, 0, 1)"
    );
    return $color[$n];
}
