<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Collection;
use App\HargaIkan;
use App\Report;
use App\JenisIkan;
use App\JenisLahan;
use App\Kecamatan;
use App\Desa;
use Response;
use App\Exports\DataExport;
use App\Exports\DetailExport;
use App\Imports\DataImport;
use App\Imports\DetailImport;
use Maatwebsite\Excel\Facades\Excel;
use Rap2hpoutre\FastExcel\FastExcel;
use Auth;
use App\Exports\CetakHargaTotal;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use Illuminate\Support\Facades\Validator;

class DataController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    
    public function index()
    {
        if(Auth::user()->id_jabatan == 1){
            $kecamatan = Kecamatan::all();
            $desa = DB::table('desa')->join('kecamatan', 'kecamatan.id_kecamatan', 'desa.id_kecamatan')->get();
        }else{
            $kecamatan = Kecamatan::where('id_kecamatan', Auth::user()->id_kecamatan)->get();
            $desa = DB::table('desa')->join('kecamatan', 'kecamatan.id_kecamatan', 'desa.id_kecamatan')->where('kecamatan.id_kecamatan', Auth::user()->id_kecamatan)->get();
        }
        return view('data.index')->with('desa', $desa)->with('kecamatan', $kecamatan);
    }

    public function detail($id_desa,$tahun,$jns_lahan)
    {
        if($tahun !== Auth::user()->tahun_data){
            return abort(404);
        }else{
            $lahan = DB::table('jenis_lahan')->get();
            $desa = DB::table('desa')->where('id_desa', $id_desa)->first();
            $ikan = DB::table('jenis_ikan')->get();
            $nama_lahan = DB::table('jenis_lahan')->where('id_lahan', $jns_lahan)->first();
            $luas_kolam = DB::table('lahan')->where('kd_desa', $id_desa)->where('kd_lahan', $jns_lahan)->where('tahun', $tahun)->first();
            $rtp_kolam = DB::table('rtp')->where('kd_desa', $id_desa)->where('kd_lahan', $jns_lahan)->where('tahun', $tahun)->first();
            $report = DB::table('report')->where('id_desa', $id_desa)->where('kd_lahan', $jns_lahan)->where('tahun', $tahun)->get();
            $data = array();
            for ($bln=1; $bln <=12 ; $bln++) {
                $b = $bln;
                $qty=[];
                $o=1;
                foreach ($ikan as $ik) {
                    if (count($report) > 0){
                        foreach ($report as $rep){
                            if ($rep->bulan == $bln){
                                if($rep->id_ikan == $ik->id_ikan){
                                    $qty[$ik->id_ikan]= $rep->qty;
                                }else{
                                }
                            }else{
                            }
                        }
                    }else{
                    }
                    $o++;
                }
                
                array_push($data, [
                    'bulan' => $bln,
                    'qty'        => $qty
                ]);
            }
            return view('data.detail')
                ->with('id_desa', $id_desa)
                ->with('tahun', $tahun)
                ->with('jns_lahan', $jns_lahan)
                ->with('data', $data)
                ->with('lahan', $lahan)
                ->with('desa', $desa)
                ->with('ikan', $ikan)
                // ->with('report', $report)
                ->with('luas_kolam', $luas_kolam)
                ->with('rtp_kolam', $rtp_kolam)
                ->with('nama_lahan', $nama_lahan);
        }
    }

    public function saveReport(Request $request){
        $id_ikan = $request->input('id_ikan');
        $val = $request->input('value');
        $kd_lahan = $request->input('kd_lahan');
        $bulan = $request->input('bulan');
        $tahun = $request->input('tahun');
        $id_desa = $request->input('id_desa');

        Report::where('id_ikan', $id_ikan)
        ->where('id_desa', $id_desa)
        ->where('kd_lahan', $kd_lahan)
        ->where('bulan', $bulan)
        ->where('tahun', $tahun)
        ->delete();

        $Masukan = new Report;
        $Masukan->id_desa = $id_desa;
        $Masukan->id_ikan = $id_ikan;
        $Masukan->kd_lahan = $kd_lahan;
        $Masukan->qty = $val;
        $Masukan->bulan = $bulan;
        $Masukan->tahun = $tahun;
        $Masukan->save();
        return $val;
    }
    

    public function harga($kl, $th)
    {
        if($th !== Auth::user()->tahun_data){
            return abort(404);
        }else{
            $lahan = JenisLahan::all();
            $nama_lahan = JenisLahan::where('id_lahan', $kl)->first();
            $data_ikan = JenisIkan::all();
            $data_harga = HargaIkan::where('kd_lahan', $kl)->where('tahun', $th)
            ->orderBy('id_ikan')->get();
            $data_report = Report::where('kd_lahan', $kl)->where('tahun', $th)
            ->select(DB::raw('SUM(qty) as qty'),'bulan', 'id_ikan', 'tahun')
            ->groupBy('id_ikan')
            ->groupBy('bulan')
            ->groupBy('tahun')
            ->orderBy('id_ikan')->get();
            $hargasatuan = array();
            foreach ($data_ikan as $ik) {
                for ($i = 1; $i <= 12; $i++) {
                    $hargasatuan[$ik['id_ikan']][$i] = 0;
                }
            }
            foreach ($data_harga as $hr) {
                $hargasatuan[$hr['id_ikan']][$hr['bulan']] = $hr['harga'];
            }

            $data_harganya = array();
            for ($i = 1; $i <= 12; $i++) {
                foreach ($data_ikan as $ikn) {
                    $data_harganya[$i][$ikn['id_ikan']] = 0;
                }
            }
            if (count($data_report) > 0) {
                foreach ($data_report as $dr) {
                    if($dr['bulan'] != null | $dr['bulan'] != ''){
                        $data_harganya[$dr['bulan']][$dr['id_ikan']] = $dr['qty'];
                    }
                }
            }
            $data_bawah = array();
            
            foreach($data_harganya as $key => $value){
                $totalsamping =0;
                $ikn = array();
                foreach ($value as $k => $v){
                    $harga_ikan = $hargasatuan[$k][$key];
                    $hargakali = $v * $harga_ikan;
                    $totalsamping += $hargakali;
                    $ikn[$k] = $hargakali;
                }
                array_push($data_bawah,[
                    'bulan' => $key,
                    'ikn'   => $ikn,
                    'ttl'   => $totalsamping
                ]);
            }

            return view('data.harga')
            ->with('tahun', $th)
            ->with('kl', $kl)
            ->with('nama_lahan', $nama_lahan)
            ->with('jenis_lahan', $lahan)
            ->with('ikan', $data_ikan)
            ->with('harga', $data_harga)
            ->with('data_bawah', $data_bawah);
        }
    }

    public function saveHarga(Request $request){
        $id_ikan = $request->input('id_ikan');
        $val = $request->input('value');
        $kd_lahan = $request->input('kd_lahan');
        $bulan = $request->input('bulan');
        $tahun = $request->input('tahun');

        $cek = HargaIkan::where('id_ikan', $id_ikan)
        ->where('kd_lahan', $kd_lahan)
        ->where('bulan', $bulan)
        ->where('tahun', $tahun)
        ->get();

        if(count($cek) > 0){
            $up = HargaIkan::where('id_ikan', $id_ikan)
            ->where('kd_lahan', $kd_lahan)
            ->where('bulan', $bulan)
            ->where('tahun', $tahun)
            ->update([
                        'harga' => $val
                    ]);
            if($up){
                return $val;
            }else{
                return "Gagal";
            }
        }else{
            $Masukan = new HargaIkan;
            $Masukan->id_ikan = $id_ikan;
            $Masukan->kd_lahan = $kd_lahan;
            $Masukan->harga = $val;
            $Masukan->bulan = $bulan;
            $Masukan->tahun = $tahun;
            $Masukan->save();
            return $val;
        }
    }

    public function cetakTotalIkan($kl, $th)
    {
        if($th !== Auth::user()->tahun_data){
            return abort(404);
        }else{
            $data_ikan = JenisIkan::all();
            $data_harga = HargaIkan::where('kd_lahan', $kl)->where('tahun', $th)
            ->orderBy('id_ikan')->get();
            $data_report = Report::where('kd_lahan', $kl)->where('tahun', $th)
            ->select(DB::raw('SUM(qty) as qty'),'bulan', 'id_ikan')
            ->groupBy('id_ikan')
            ->groupBy('bulan')
            ->groupBy('tahun')
            ->orderBy('id_ikan')->get();

            $jns_lahan = JenisLahan::where('id_lahan', $kl)->first();
            $nama_lahan = $jns_lahan->nama_lahan;

            $hargasatuan = array();
            foreach ($data_ikan as $ik) {
                for ($i = 1; $i <= 12; $i++) {
                    $hargasatuan[$ik['id_ikan']][$i] = 0;
                }
            }
            foreach ($data_harga as $hr) {
                $hargasatuan[$hr['id_ikan']][$hr['bulan']] = $hr['harga'];
            }

            $data_harganya = array();
            for ($i = 1; $i <= 12; $i++) {
                foreach ($data_ikan as $ikn) {
                    $data_harganya[$i][$ikn['id_ikan']] = 0;
                }
            }
            if (count($data_report) > 0) {
                foreach ($data_report as $dr) {
                    if($dr['bulan'] != null | $dr['bulan'] != ''){
                        $data_harganya[$dr['bulan']][$dr['id_ikan']] = $dr['qty'];
                    }
                }
            }
            $data_bawah = array();
            foreach($data_harganya as $key => $value){
                $totalsamping =0;
                $ikn = array();
                foreach ($value as $k => $v){
                    $harga_ikan = $hargasatuan[$k][$key];
                    $hargakali = $v * $harga_ikan;
                    $totalsamping += $hargakali;
                    $ikn[$k] = $hargakali;
                }
                array_push($data_bawah,[
                    'bulan' => $key,
                    'ikn'   => $ikn,
                    'ttl'   => $totalsamping
                ]);
            }

            // return view('data.cetakhargaTotal')
            // ->with('ikan', $data_ikan)
            // ->with('data_bawah', $data_bawah);
            return Excel::download(new CetakHargaTotal($data_ikan, $data_bawah), 'Harga_Total_'.$nama_lahan.'_'.$th.'.xlsx');
        }
    }

    public function download_form(Request $request)
    {
        $id_kec = $request->input('kecamatan');
        $bul = $request->input('bulan');
        $thn = Date('Y');
        if ($bul == "01") {
            $bulane = "Januari";
        } elseif ($bul == "02") {
            $bulane = "Februari";
        } elseif ($bul == "03") {
            $bulane = "Maret";
        } elseif ($bul == "04") {
            $bulane = "April";
        } elseif ($bul == "05") {
            $bulane = "Mei";
        } elseif ($bul == "06") {
            $bulane = "Juni";
        } elseif ($bul == "07") {
            $bulane = "Juli";
        } elseif ($bul == "08") {
            $bulane = "Agustus";
        } elseif ($bul == "09") {
            $bulane = "September";
        } elseif ($bul == "10") {
            $bulane = "Oktober";
        } elseif ($bul == "11") {
            $bulane = "November";
        } elseif ($bul == "12") {
            $bulane = "Desember";
        }
        $kecamatan = Kecamatan::where('id_kecamatan', $id_kec)->first();
        $desa = Desa::where('id_kecamatan', $id_kec)->get();
        $jns_lahan=JenisLahan::all();
        $ikan=JenisIkan::all();
        return Excel::download(new DataExport($kecamatan, $desa, $jns_lahan, $ikan, $thn, $bulane), 'form.xlsx');
    }

    public function upload_form(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'file_excel' => [
                    'required',
                    'file',
                    'max:2000',
                    'mimes:csv,xlsx, application/vnd.ms-excel'
                ],
            ],[
                'required' => 'Kamu harus pilih file excelnya...',
                'max'       => 'Ukuran maksimal 2 Mb',
                'mimes' => 'File anda tidak dalam format yang benar..'
            ]
        );
 
        if ($validator->fails()) {
            return redirect('data')->withErrors($validator);
        }

        $validated = $validator->validated();

        $file = $request->file('file_excel');
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load($file);
        $sheetData = $spreadsheet->getActiveSheet()->toArray();
        $idikan = [];
        for ($i=5; $i < count($sheetData[0]); $i++) { 
            $dataidikan = explode(":", $sheetData[0][$i]);
            $idikan[$i] = $dataidikan[0];
        }

        for ($i=1; $i < count($sheetData); $i++) {
            $id_desa = get_desa($sheetData[$i][0], $sheetData[$i][1]);
            $id_lahan = get_lahan($sheetData[$i][2]);
            $bulane = nama_bulan($sheetData[$i][4]);
            $tahun = $sheetData[$i][3];
            if($id_desa != null){
                foreach ($idikan as $key => $value) {
                    $qt = $sheetData[$i][$key];
                    if($qt != ''){
                            $cek = DB::table('report')
                                    ->where('id_desa', (String)$id_desa)
                                    ->where('kd_lahan', (Int)$id_lahan)
                                    ->where('bulan', (String)$bulane)
                                    ->where('tahun', (Int)$tahun)
                                    ->where('id_ikan', (Int)$value)
                                    ->exists();
                            if ($cek) {
                                do_update((String)$id_desa, (Int)$id_lahan, (String)$bulane, (Int)$tahun, (Int)$value, (String)$qt);
                            }else{
                                do_insert((String)$id_desa, (Int)$id_lahan, (String)$bulane, (Int)$tahun, (Int)$value, (String)$qt);
                            }
                    }
                }
            }
        }
        return redirect('/data');
    }

    public function export_detail($id_desa, $id_lahan, $tahun)
    {
        $desa = Desa::where('id_desa', $id_desa)->first();
        $namadesa = $desa->nama_desa;
        $ikan=JenisIkan::all();
        return Excel::download(new DetailExport($desa, $id_lahan, $ikan, $tahun), 'form_'.$namadesa.'_'.$tahun.'.xlsx');
    }

    public function upload_detail_form(Request $request)
    {
        $id_desa = $request->id_desa;
        $tahun = Date('Y');

        $validator = Validator::make(
            $request->all(),
            [
                'file_excel' => [
                    'required',
                    'file',
                    'max:2000',
                    'mimes:csv,xlsx, application/vnd.ms-excel'
                ],
            ],[
                'required' => 'Kamu harus pilih file excelnya...',
                'max'       => 'Ukuran maksimal 2 Mb',
                'mimes' => 'File anda tidak dalam format yang benar..'
            ]
        );
 
        if ($validator->fails()) {
            return redirect('/data/detail/'.$id_desa.'/'.$tahun.'/1')->withErrors($validator);
        }

        $validated = $validator->validated();
        $file = $validated['file_excel'];
        // $file = $request->file('file_excel');
        Excel::import(new DetailImport, $file);
        return redirect('/data/detail/'.$id_desa.'/'.$tahun.'/1');
    }

    public function update_rtp(Request $request)
    {
        $id_desa = $request->id_desa;
        $tahun = $request->tahun;
        $lahan = $request->lahan;
        $luas_kolam = $request->luas_kolam;
        $rtp_kolam = $request->rtp_kolam;
        
        $cek_lahan = DB::table('lahan')->where('kd_desa', $id_desa)->where('kd_lahan', $lahan)->where('tahun', $tahun)->get();
        if(count($cek_lahan) > 0){
            DB::table('lahan')
            ->where('kd_desa', $id_desa)
            ->where('kd_lahan', $lahan)
            ->where('tahun', $tahun)->update([
                'qty' => $luas_kolam
            ]);
        }else{
            DB::table('lahan')->insert([
                'kd_desa'   => $id_desa,
                'kd_lahan'  => $lahan,
                'qty'       => $luas_kolam,
                'tahun'     => $tahun
            ]);
        }

        $cek_rtp = DB::table('rtp')->where('kd_desa', $id_desa)->where('kd_lahan', $lahan)->where('tahun', $tahun)->get();
        if(count($cek_rtp) > 0){
            DB::table('rtp')
            ->where('kd_desa', $id_desa)
            ->where('kd_lahan', $lahan)
            ->where('tahun', $tahun)->update([
                'qty' => $rtp_kolam
            ]);
        }else{
            DB::table('rtp')->insert([
                'kd_desa'   => $id_desa,
                'kd_lahan'  => $lahan,
                'qty'       => $rtp_kolam,
                'tahun'     => $tahun
            ]);
        }
        return redirect('/data/detail/'.$id_desa.'/'.$tahun.'/'.$lahan);
    }

}

function get_desa($nm_kec, $nm_desa){
    $kec = DB::table('kecamatan')->where('nama_kecamatan', $nm_kec)->first();
    $id_kec = $kec->id_kecamatan;
    $desa = DB::table('desa')->where('nama_desa', $nm_desa)->where('id_kecamatan', $id_kec)->first();
    return $desa->id_desa;
}
function get_lahan($nm_lahan){
    $lahan = DB::table('jenis_lahan')->where('nama_lahan', $nm_lahan)->first();
    return $lahan->id_lahan;
}
function nama_bulan($b){
    $bulane ='';
    if ( $b == "Januari") {
        $bulane = "1";
    } elseif ( $b == "Februari") {
        $bulane = "2";
    } elseif ( $b == "Maret") {
        $bulane = "3";
    } elseif ( $b == "April") {
        $bulane = "4";
    } elseif ( $b == "Mei") {
        $bulane = "5";
    } elseif ( $b == "Juni") {
        $bulane = "6";
    } elseif ( $b == "Juli") {
        $bulane = "7";
    } elseif ( $b == "Agustus") {
        $bulane = "8";
    } elseif ( $b == "September") {
        $bulane = "9";
    } elseif ( $b == "Oktober") {
        $bulane = "10";
    } elseif ( $b == "November") {
        $bulane = "11";
    } elseif ( $b == "Desember") {
        $bulane = "12";
    }
    return $bulane;
}
function do_insert($desa, $lahan, $bln, $thn, $ikan, $qty){
    
    DB::table('report')
            ->insert([
                'id_desa'   => $desa,
                'kd_lahan'  => $lahan,
                'bulan' => $bln,
                'tahun' => $thn,
                'id_ikan'   => $ikan,
                'qty' => $qty
            ]);
}
function do_update($desa, $lahan, $bln, $thn, $ikan, $qty){
    DB::table('report')
            ->where('id_desa', $desa)
            ->where('kd_lahan', $lahan)
            ->where('bulan', $bln)
            ->where('tahun', $thn)
            ->where('id_ikan', $ikan)
            ->update(array(
                'qty' => $qty
            ));
}
