<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Kecamatan;
use App\Desa;
use App\JenisIkan;
use Auth;
use Response;
use Storage;
use File;
use Validator;
use Redirect;

class BeritaController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $data = DB::table('berita')->get();
        return view('berita.index')->with('data', $data);
    }

    public function tulis()
    {
        return view('berita.tulis_berita');
    }

    public function store_berita(Request $request){
        $rules = array(
            'judul' => 'required',
            'isi' => 'required'
        );      
        $messages = array(
            'required' => 'Kolom :attribute harus di isi.',
            'integer' => 'Kolom :attribute harus dipilih'
        );
        $validator = Validator::make($request->all(), $rules,$messages);
        if ($validator->fails())
        {   
            return Redirect::to('/berita/tulis')->withErrors($validator)->withInput();
        }else{
            $file = $request->file('gambar_berita');
            $extension = $file->getClientOriginalExtension();
            Storage::disk('berita')->put($file->getFilename().'.'.$extension,  File::get($file));
            $filegambar = $file->getFilename().'.'.$extension;
            DB::table('berita')->insert(array(
                'judul'             => $request->input('judul'),
                'slug'              => "-",
                'foto'              => $filegambar,
                'isi'               => $request->input('isi'),
                'tanggal'           => Date('Y-m-d h:i:s'),
                'author'            => Auth::user()->name,
            ));
            return redirect('/berita');
        }
    }

    public function edit_berita($id){
        $data = DB::table('berita')->where('id', $id)->first();
        return view('berita.edit')->with('data', $data);
    }

    public function update_berita(Request $request){
        $id = $request->input('id');
        $file = $request->file('gambar_berita');
        if ($file != null) {  
            $data = DB::table('berita')->where('id', $id)->first();
            Storage::disk('berita')->delete($data->foto);
            $extension = $file->getClientOriginalExtension();
            Storage::disk('berita')->put($file->getFilename().'.'.$extension,  File::get($file));
            $filegambar = $file->getFilename().'.'.$extension;
            DB::table('berita')->where('id', $id)->update(array(
                'judul'        => $request->input('judul'),
                'isi'          => $request->input('isi'),
                'foto'         => $filegambar,
                'tanggal'   => date('Y-m-d H:i:s'),
                'author'            => Auth::user()->name,
            ));
        }else{
            DB::table('berita')->where('id', $id)->update(array(
                'judul'        => $request->input('judul'),
                'isi'          => $request->input('isi'),
                'tanggal'   => date('Y-m-d H:i:s'),
                'author'            => Auth::user()->name
            ));
        }
        return redirect('berita');
    }

    public function lihat_berita($id){
        $data = DB::table('berita')->where('id', $id)->first();
        return view('berita.lihat')->with('data', $data);
    }

    public function hapus_berita(Request $request, $id){
        $data = DB::table('berita')->where('id', $id)->first();
        Storage::disk('berita')->delete($data->foto);
        DB::table('berita')->where('id', $id)->delete();
        return redirect('berita');
    }

}
