<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;
use App\User;
use Auth;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function login(Request $request)

    {   

        $input = $request->all();
        $this->validate($request, [

            'email' => 'required',

            'password' => 'required',

        ]);

        if(auth()->attempt(array('email' => $input['email'], 'password' => $input['password'])))
        {
            User::where('id', Auth::user()->id)->update(array(
                'tahun_data'    => $input['tahun']
            ));
            return redirect()->route('home');
        }else{
            return redirect()->route('login')->with('error','Email-Address And Password Are Wrong.');
        }
    }

    public function logout(Request $request)
    {
        $userId = Auth::user()->id;

        User::where('id', $userId)->update(array(
            'tahun_data'    => NULL
        ));

        Cache::forget('user-session-' . $userId);

        $this->guard()->logout();
 
        $request->session()->flush();
 
        $request->session()->regenerate();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
 
        // return redirect('/');
        return $this->loggedOut($request) ?: redirect('/');
    }

}
