<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class CetakRekapRTP implements FromView, ShouldAutoSize
{
    private $awl, $akhr, $data_rekap;
    
    public function __construct($awl, $akhr, $data_rekap)
    {
        $this->awl = $awl;
        $this->akhr = $akhr;
        $this->data_rekap = $data_rekap;
    }
    
    public function view(): View
    {
        return view('rekap.cetak_rtp', [
            'data_rekap' => $this->data_rekap,
            'thn_awal'  => $this->awl,
            'thn_akhir' => $this->akhr
        ]);
    }
}
