<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class CetakRekapDesaTahun implements FromView, ShouldAutoSize
{
    /**
    * @return \Illuminate\Support\Collection
    */

    private $ikan, $data_rekap, $nama_kecamatan;

    public function __construct($ikan, $data_rekap, $nama_kecamatan)
    {
        $this->ikan = $ikan;
        $this->data_rekap = $data_rekap;
        $this->nama_kecamatan = $nama_kecamatan;
    }
    
    public function view(): View
    {
        return view('rekap.cetak_desa_tahun', [
            'ikan' => $this->ikan,
            'data_rekap' => $this->data_rekap,
            'nama_kecamatan' => $this->nama_kecamatan
        ]);
    }
    
}
