<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class CetakHargaTotal implements FromView, ShouldAutoSize
{
    /**
    * @return \Illuminate\Support\Collection
    */

    private $data_ikan, $data_bawah;

    public function __construct($data_ikan, $data_bawah)
    {
        $this->data_ikan = $data_ikan;
        $this->data_bawah = $data_bawah;
    }
    
    public function view(): View
    {
        return view('data.cetakhargaTotal', [
            'data_ikan' => $this->data_ikan,
            'data_bawah' => $this->data_bawah
        ]);
    }
    
}
